/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.state;

import io.camunda.connector.runtime.inbound.executable.InboundExecutableRegistry;
import io.camunda.connector.runtime.inbound.state.ProcessDefinitionInspector;
import io.camunda.connector.runtime.inbound.state.ProcessImportResult;
import io.camunda.connector.runtime.inbound.state.ProcessStateStore;
import io.camunda.connector.runtime.inbound.state.ProcessStateStoreImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class TenantAwareProcessStateStoreImpl
implements ProcessStateStore {
    private final ConcurrentHashMap<String, ProcessStateStoreImpl> processStateStores = new ConcurrentHashMap();
    private final ProcessDefinitionInspector processDefinitionInspector;
    private final InboundExecutableRegistry executableRegistry;

    public TenantAwareProcessStateStoreImpl(ProcessDefinitionInspector processDefinitionInspector, InboundExecutableRegistry executableRegistry) {
        this.processDefinitionInspector = processDefinitionInspector;
        this.executableRegistry = executableRegistry;
    }

    @Override
    public void update(ProcessImportResult processDefinitions) {
        Map<String, List<Map.Entry>> groupedByTenant = processDefinitions.processDefinitionVersions().entrySet().stream().collect(Collectors.groupingBy(entry -> ((ProcessImportResult.ProcessDefinitionIdentifier)entry.getKey()).tenantId()));
        groupedByTenant.forEach((tenantId, definitions) -> {
            ProcessStateStoreImpl store = this.processStateStores.computeIfAbsent((String)tenantId, key -> new ProcessStateStoreImpl(this.processDefinitionInspector, this.executableRegistry));
            ProcessImportResult tenantProcessDefinitions = new ProcessImportResult(definitions.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            store.update(tenantProcessDefinitions);
        });
    }
}

