/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.webhook;

import io.camunda.connector.runtime.inbound.executable.RegisteredExecutable;
import io.camunda.connector.runtime.inbound.webhook.WebhookConnectorValidationUtil;
import io.camunda.connector.runtime.inbound.webhook.model.CommonWebhookProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookConnectorRegistry {
    private final Logger LOG = LoggerFactory.getLogger(WebhookConnectorRegistry.class);
    private final Map<String, RegisteredExecutable.Activated> activeEndpointsByContext = new HashMap<String, RegisteredExecutable.Activated>();

    public Optional<RegisteredExecutable.Activated> getWebhookConnectorByContextPath(String context) {
        return Optional.ofNullable(this.activeEndpointsByContext.get(context));
    }

    public boolean isRegistered(RegisteredExecutable.Activated connector) {
        String context = ((CommonWebhookProperties)connector.context().bindProperties(CommonWebhookProperties.class)).getContext();
        return this.activeEndpointsByContext.containsKey(context) && this.activeEndpointsByContext.get(context) == connector;
    }

    public void register(RegisteredExecutable.Activated connector) {
        CommonWebhookProperties properties = (CommonWebhookProperties)connector.context().bindProperties(CommonWebhookProperties.class);
        String context = properties.getContext();
        if (context == null) {
            String logMessage = "Webhook path not provided";
            this.LOG.debug(logMessage);
            throw new RuntimeException(logMessage);
        }
        WebhookConnectorValidationUtil.logIfWebhookPathDeprecated(connector, context);
        RegisteredExecutable.Activated existingEndpoint = this.activeEndpointsByContext.putIfAbsent(context, connector);
        this.checkIfEndpointExists(existingEndpoint, context);
    }

    private void checkIfEndpointExists(RegisteredExecutable.Activated existingEndpoint, String context) {
        if (existingEndpoint != null) {
            Map elementIdsByProcessId = existingEndpoint.context().getDefinition().elements().stream().collect(HashMap::new, (map, element) -> map.put(element.bpmnProcessId(), element.elementId()), HashMap::putAll);
            String logMessage = "Context: " + context + " already in use by: " + elementIdsByProcessId.entrySet().stream().map(e -> "process " + (String)e.getKey() + "(" + (String)e.getValue() + ")").reduce((a, b) -> a + ", " + b).orElse("");
            this.LOG.debug(logMessage);
            throw new RuntimeException(logMessage);
        }
    }

    public void deregister(RegisteredExecutable.Activated connector) {
        String context = ((CommonWebhookProperties)connector.context().bindProperties(CommonWebhookProperties.class)).getContext();
        RegisteredExecutable.Activated registeredConnector = this.activeEndpointsByContext.get(context);
        if (registeredConnector == null) {
            String logMessage = "Context: " + context + " is not registered. Cannot deregister.";
            this.LOG.debug(logMessage);
            throw new RuntimeException(logMessage);
        }
        String requesterDeduplicationId = connector.context().getDefinition().deduplicationId();
        String registeredDeduplicationId = registeredConnector.context().getDefinition().deduplicationId();
        if (!registeredDeduplicationId.equals(requesterDeduplicationId)) {
            String logMessage = "Context: " + context + " is not registered by the connector with deduplication ID: " + requesterDeduplicationId + ". Cannot deregister.";
            this.LOG.debug(logMessage);
            throw new RuntimeException(logMessage);
        }
        this.activeEndpointsByContext.remove(context);
    }

    public void reset() {
        this.activeEndpointsByContext.clear();
    }
}

