/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.secret;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.common.auth.Authentication;
import io.camunda.common.auth.JwtConfig;
import io.camunda.common.auth.JwtCredential;
import io.camunda.common.auth.Product;
import io.camunda.common.auth.SaaSAuthenticationBuilder;
import io.camunda.common.json.JsonMapper;
import io.camunda.common.json.SdkObjectMapper;
import io.camunda.connector.api.json.ConnectorsObjectMapperSupplier;
import java.io.IOException;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleSecretApiClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsoleSecretApiClient.class);
    private final String secretsEndpoint;
    private final Authentication authentication;
    private final ObjectMapper objectMapper = ConnectorsObjectMapperSupplier.DEFAULT_MAPPER;
    private static final TypeReference<Map<String, String>> mapTypeReference = new TypeReference<Map<String, String>>(){};

    public ConsoleSecretApiClient(String secretsEndpoint, JwtCredential jwt) {
        SdkObjectMapper jsonMapper = new SdkObjectMapper(ConnectorsObjectMapperSupplier.DEFAULT_MAPPER);
        JwtConfig jwtConfig = new JwtConfig();
        jwtConfig.addProduct(Product.CONSOLE, jwt);
        this.authentication = ((SaaSAuthenticationBuilder)new SaaSAuthenticationBuilder().withJsonMapper((JsonMapper)jsonMapper).withJwtConfig(jwtConfig)).build();
        this.secretsEndpoint = secretsEndpoint;
    }

    public ConsoleSecretApiClient(String secretsEndpoint, Authentication authentication) {
        this.secretsEndpoint = secretsEndpoint;
        this.authentication = authentication;
    }

    public Map<String, String> getSecrets() {
        Map map;
        block8: {
            LOGGER.debug("Loading secrets from " + this.secretsEndpoint);
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            try {
                HttpGet request = new HttpGet(this.secretsEndpoint);
                Map authHeader = this.authentication.getTokenHeader(Product.CONSOLE);
                authHeader.forEach((arg_0, arg_1) -> ((HttpGet)request).addHeader(arg_0, arg_1));
                map = (Map)httpClient.execute((ClassicHttpRequest)request, this::handleSecretsResponse);
                if (httpClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (httpClient != null) {
                        try {
                            httpClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            httpClient.close();
        }
        return map;
    }

    private Map<String, String> handleSecretsResponse(ClassicHttpResponse response) throws IOException {
        switch (response.getCode()) {
            case 200: {
                break;
            }
            case 401: 
            case 403: {
                this.authentication.resetToken(Product.CONSOLE);
                throw new RuntimeException("Authentication failed: " + response.getCode());
            }
            default: {
                throw new RuntimeException("Unable to handle response from Console secrets: " + response.getCode());
            }
        }
        return (Map)this.objectMapper.readValue(response.getEntity().getContent(), mapTypeReference);
    }
}

