/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.util.outbound;

import io.camunda.connector.api.error.BpmnError;
import io.camunda.connector.api.error.ConnectorException;
import io.camunda.connector.api.outbound.OutboundConnectorContext;
import io.camunda.connector.api.outbound.OutboundConnectorFunction;
import io.camunda.connector.api.secret.SecretProvider;
import io.camunda.connector.runtime.util.ConnectorHelper;
import io.camunda.connector.runtime.util.outbound.ConnectorResult;
import io.camunda.connector.runtime.util.outbound.JobHandlerContext;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.client.api.worker.JobHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorJobHandler
implements JobHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectorJobHandler.class);
    protected final OutboundConnectorFunction call;

    public ConnectorJobHandler(OutboundConnectorFunction call) {
        this.call = call;
    }

    public void handle(JobClient client, ActivatedJob job) {
        LOGGER.info("Received job {}", (Object)job.getKey());
        ConnectorResult result = new ConnectorResult();
        try {
            result.setResponseValue(this.call.execute((OutboundConnectorContext)new JobHandlerContext(job, this.getSecretProvider())));
            result.setVariables(ConnectorHelper.createOutputVariables(result.getResponseValue(), job.getCustomHeaders()));
        }
        catch (Exception ex) {
            LOGGER.debug("Exception while processing job {}, error: {}", (Object)job.getKey(), (Object)ex);
            result.setResponseValue(Map.of("error", ConnectorJobHandler.toMap(ex)));
            result.setException(ex);
        }
        try {
            ConnectorHelper.examineErrorExpression(result.getResponseValue(), job.getCustomHeaders()).ifPresentOrElse(error -> {
                LOGGER.debug("Throwing BPMN error for job {} with code {}", (Object)job.getKey(), (Object)error.getCode());
                this.throwBpmnError(client, job, (BpmnError)error);
            }, () -> {
                if (result.isSuccess()) {
                    LOGGER.debug("Completing job {}", (Object)job.getKey());
                    this.completeJob(client, job, result);
                } else {
                    this.logError(job, result.getException());
                    this.failJob(client, job, result.getException());
                }
            });
        }
        catch (Exception ex) {
            this.logError(job, ex);
            this.failJob(client, job, ex);
        }
    }

    protected SecretProvider getSecretProvider() {
        Iterator<SecretProvider> secretProviders = ServiceLoader.load(SecretProvider.class).iterator();
        if (!secretProviders.hasNext()) {
            this.getEnvSecretProvider();
        }
        return secretProviders.next();
    }

    protected SecretProvider getEnvSecretProvider() {
        return System::getenv;
    }

    protected void logError(ActivatedJob job, Exception ex) {
        LOGGER.error("Exception while processing job {}, error: {}", (Object)job.getKey(), (Object)ex);
    }

    protected void completeJob(JobClient client, ActivatedJob job, ConnectorResult result) {
        client.newCompleteCommand(job).variables(result.getVariables()).send().join();
    }

    protected void failJob(JobClient client, ActivatedJob job, Exception exception) {
        client.newFailCommand(job).retries(0).errorMessage(exception.getMessage()).send().join();
    }

    protected void throwBpmnError(JobClient client, ActivatedJob job, BpmnError value) {
        client.newThrowErrorCommand(job).errorCode(value.getCode()).errorMessage(value.getMessage()).send().join();
    }

    protected static Map<String, Object> toMap(Exception exception) {
        String code;
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("type", exception.getClass().getName());
        String message = exception.getMessage();
        if (message != null) {
            result.put("message", message);
        }
        if (exception instanceof ConnectorException && (code = ((ConnectorException)exception).getErrorCode()) != null) {
            result.put("code", code);
        }
        return Map.copyOf(result);
    }
}

