/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.connector.api.error.BpmnError;
import io.camunda.connector.runtime.util.feel.FeelEngineWrapper;
import io.camunda.connector.runtime.util.feel.FeelEngineWrapperException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ConnectorHelper {
    public static FeelEngineWrapper FEEL_ENGINE_WRAPPER = new FeelEngineWrapper();
    public static ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String ERROR_CANNOT_PARSE_VARIABLES = "Cannot parse '%s' as '%s'.";
    public static final String RESULT_VARIABLE_HEADER_NAME = "resultVariable";
    public static final String RESULT_EXPRESSION_HEADER_NAME = "resultExpression";
    public static final String ERROR_EXPRESSION_HEADER_NAME = "errorExpression";

    public static Map<String, Object> createOutputVariables(Object responseContent, Map<String, String> jobHeaders) {
        HashMap<String, Object> outputVariables = new HashMap<String, Object>();
        String resultVariableName = jobHeaders.get(RESULT_VARIABLE_HEADER_NAME);
        String resultExpression = jobHeaders.get(RESULT_EXPRESSION_HEADER_NAME);
        if (resultVariableName != null && !resultVariableName.isBlank()) {
            outputVariables.put(resultVariableName, responseContent);
        }
        Optional.ofNullable(resultExpression).filter(s -> !s.isBlank()).map(expression -> FEEL_ENGINE_WRAPPER.evaluateToJson((String)expression, responseContent)).map(json -> ConnectorHelper.parseJsonVarsAsTypeOrThrow(json, Map.class, resultExpression)).ifPresent(outputVariables::putAll);
        return outputVariables;
    }

    public static Optional<BpmnError> examineErrorExpression(Object responseContent, Map<String, String> jobHeaders) {
        String errorExpression = jobHeaders.get(ERROR_EXPRESSION_HEADER_NAME);
        return Optional.ofNullable(errorExpression).filter(s -> !s.isBlank()).map(expression -> FEEL_ENGINE_WRAPPER.evaluateToJson((String)expression, responseContent)).map(json -> ConnectorHelper.parseJsonVarsAsTypeOrThrow(json, BpmnError.class, errorExpression)).filter(BpmnError::hasCode);
    }

    public static <T> T instantiateConnector(Class<? extends T> connectorClass) {
        try {
            return connectorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to instantiate connector " + connectorClass, e);
        }
    }

    private static <T> T parseJsonVarsAsTypeOrThrow(String jsonVars, Class<T> type, String expression) {
        try {
            return (T)OBJECT_MAPPER.readValue(jsonVars, type);
        }
        catch (JsonProcessingException e) {
            throw new FeelEngineWrapperException(String.format(ERROR_CANNOT_PARSE_VARIABLES, jsonVars, type.getName()), expression, jsonVars, e);
        }
    }
}

