/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.util.inbound.correlation;

import io.camunda.connector.api.error.ConnectorException;
import io.camunda.connector.api.inbound.InboundConnectorResult;
import io.camunda.connector.api.inbound.ProcessCorrelationPoint;
import io.camunda.connector.impl.inbound.correlation.MessageCorrelationPoint;
import io.camunda.connector.impl.inbound.correlation.StartEventCorrelationPoint;
import io.camunda.connector.runtime.util.feel.FeelEngineWrapper;
import io.camunda.connector.runtime.util.inbound.correlation.MessageInboundConnectorResult;
import io.camunda.connector.runtime.util.inbound.correlation.StartEventInboundConnectorResult;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import io.camunda.zeebe.client.api.response.PublishMessageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InboundCorrelationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(InboundCorrelationHandler.class);
    private final ZeebeClient zeebeClient;
    private final FeelEngineWrapper feelEngine;

    public InboundCorrelationHandler(ZeebeClient zeebeClient, FeelEngineWrapper feelEngine) {
        this.zeebeClient = zeebeClient;
        this.feelEngine = feelEngine;
    }

    public InboundConnectorResult correlate(ProcessCorrelationPoint correlationPoint, Object variables) {
        if (correlationPoint instanceof StartEventCorrelationPoint) {
            return this.triggerStartEvent((StartEventCorrelationPoint)correlationPoint, variables);
        }
        if (correlationPoint instanceof MessageCorrelationPoint) {
            return this.triggerMessage((MessageCorrelationPoint)correlationPoint, variables);
        }
        throw new ConnectorException("Process correlation point " + correlationPoint.getClass() + " is not supported by Runtime");
    }

    private InboundConnectorResult triggerStartEvent(StartEventCorrelationPoint correlationPoint, Object variables) {
        try {
            ProcessInstanceEvent result = (ProcessInstanceEvent)this.zeebeClient.newCreateInstanceCommand().bpmnProcessId(correlationPoint.getBpmnProcessId()).version(correlationPoint.getVersion()).variables(variables).send().join();
            LOG.info("Created a process instance with key" + result.getProcessInstanceKey());
            return new StartEventInboundConnectorResult(result);
        }
        catch (Exception e) {
            throw new ConnectorException("Failed to start process instance via StartEvent: " + correlationPoint, (Throwable)e);
        }
    }

    private InboundConnectorResult triggerMessage(MessageCorrelationPoint correlationPoint, Object variables) {
        String correlationKey = (String)this.feelEngine.evaluate(correlationPoint.getCorrelationKeyExpression(), variables);
        try {
            PublishMessageResponse response = (PublishMessageResponse)this.zeebeClient.newPublishMessageCommand().messageName(correlationPoint.getMessageName()).correlationKey(correlationKey).variables(variables).send().join();
            LOG.info("Published message with key: " + response.getMessageKey());
            return new MessageInboundConnectorResult(response, correlationKey);
        }
        catch (Exception e) {
            throw new ConnectorException("Failed to publish process message for subscription: " + correlationPoint, (Throwable)e);
        }
    }
}

