/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.util.inbound.correlation;

import io.camunda.connector.api.error.ConnectorException;
import io.camunda.connector.api.inbound.InboundConnectorResult;
import io.camunda.connector.impl.inbound.InboundConnectorProperties;
import io.camunda.connector.impl.inbound.ProcessCorrelationPoint;
import io.camunda.connector.impl.inbound.correlation.MessageCorrelationPoint;
import io.camunda.connector.impl.inbound.correlation.StartEventCorrelationPoint;
import io.camunda.connector.impl.inbound.result.CorrelatedMessage;
import io.camunda.connector.impl.inbound.result.CorrelationErrorData;
import io.camunda.connector.impl.inbound.result.MessageCorrelationResult;
import io.camunda.connector.impl.inbound.result.ProcessInstance;
import io.camunda.connector.impl.inbound.result.StartEventCorrelationResult;
import io.camunda.connector.runtime.util.ConnectorHelper;
import io.camunda.connector.runtime.util.feel.FeelEngineWrapper;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import io.camunda.zeebe.client.api.response.PublishMessageResponse;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InboundCorrelationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(InboundCorrelationHandler.class);
    private final ZeebeClient zeebeClient;
    private final FeelEngineWrapper feelEngine;

    public InboundCorrelationHandler(ZeebeClient zeebeClient, FeelEngineWrapper feelEngine) {
        this.zeebeClient = zeebeClient;
        this.feelEngine = feelEngine;
    }

    public InboundConnectorResult<?> correlate(InboundConnectorProperties properties, Object variables) {
        ProcessCorrelationPoint correlationPoint = properties.getCorrelationPoint();
        if (correlationPoint instanceof StartEventCorrelationPoint) {
            return this.triggerStartEvent(properties, variables);
        }
        if (correlationPoint instanceof MessageCorrelationPoint) {
            return this.triggerMessage(properties, variables);
        }
        throw new ConnectorException("Process correlation point " + correlationPoint.getClass() + " is not supported by Runtime");
    }

    private InboundConnectorResult<ProcessInstance> triggerStartEvent(InboundConnectorProperties properties, Object variables) {
        StartEventCorrelationPoint correlationPoint = (StartEventCorrelationPoint)properties.getCorrelationPoint();
        if (!this.isActivationConditionMet(properties, variables)) {
            LOG.debug("Activation condition didn't match: {}", (Object)correlationPoint);
            return new StartEventCorrelationResult(correlationPoint.getProcessDefinitionKey(), new CorrelationErrorData(CorrelationErrorData.CorrelationErrorReason.ACTIVATION_CONDITION_NOT_MET));
        }
        Map<String, Object> extractedVariables = ConnectorHelper.createOutputVariables(variables, properties.getProperties());
        try {
            ProcessInstanceEvent result = (ProcessInstanceEvent)this.zeebeClient.newCreateInstanceCommand().bpmnProcessId(correlationPoint.getBpmnProcessId()).version(correlationPoint.getVersion()).variables(extractedVariables).send().join();
            LOG.info("Created a process instance with key" + result.getProcessInstanceKey());
            return new StartEventCorrelationResult(result.getProcessDefinitionKey(), new ProcessInstance(result.getProcessInstanceKey(), correlationPoint.getBpmnProcessId(), correlationPoint.getProcessDefinitionKey(), correlationPoint.getVersion()));
        }
        catch (Exception e) {
            throw new ConnectorException("Failed to start process instance via StartEvent: " + correlationPoint, (Throwable)e);
        }
    }

    private InboundConnectorResult<CorrelatedMessage> triggerMessage(InboundConnectorProperties properties, Object variables) {
        MessageCorrelationPoint correlationPoint = (MessageCorrelationPoint)properties.getCorrelationPoint();
        String correlationKey = this.extractCorrelationKey(properties, variables);
        if (!this.isActivationConditionMet(properties, variables)) {
            LOG.debug("Activation condition didn't match: {}", (Object)correlationPoint);
            return new MessageCorrelationResult(correlationPoint.getMessageName(), new CorrelationErrorData(CorrelationErrorData.CorrelationErrorReason.ACTIVATION_CONDITION_NOT_MET));
        }
        Map<String, Object> extractedVariables = ConnectorHelper.createOutputVariables(variables, properties.getProperties());
        try {
            PublishMessageResponse response = (PublishMessageResponse)this.zeebeClient.newPublishMessageCommand().messageName(correlationPoint.getMessageName()).correlationKey(correlationKey).variables(extractedVariables).send().join();
            LOG.info("Published message with key: " + response.getMessageKey());
            return new MessageCorrelationResult(correlationPoint.getMessageName(), response.getMessageKey());
        }
        catch (Exception e) {
            throw new ConnectorException("Failed to publish process message for subscription: " + correlationPoint, (Throwable)e);
        }
    }

    private boolean isActivationConditionMet(InboundConnectorProperties properties, Object context) {
        String activationCondition = properties.getProperty("activationCondition");
        if (activationCondition == null || activationCondition.trim().length() == 0) {
            LOG.debug("No activation condition specified for {}", (Object)properties.getCorrelationPoint());
            return true;
        }
        Object shouldActivate = this.feelEngine.evaluate(activationCondition, context);
        return Boolean.TRUE.equals(shouldActivate);
    }

    private String extractCorrelationKey(InboundConnectorProperties properties, Object context) {
        String correlationKeyExpression = properties.getRequiredProperty("correlationKeyExpression");
        try {
            return (String)this.feelEngine.evaluate(correlationKeyExpression, context);
        }
        catch (Exception e) {
            throw new ConnectorException("Failed to evaluate correlation key expression: " + correlationKeyExpression, (Throwable)e);
        }
    }
}

