/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.validation.impl;

import io.camunda.connector.api.validation.ValidationProvider;
import io.camunda.connector.impl.ConnectorInputException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Configuration;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;

public class DefaultValidationProvider
implements ValidationProvider {
    protected static final String LF = "\n";
    protected final ValidatorFactory validatorFactory;

    public DefaultValidationProvider() {
        Configuration configuration = Validation.byDefaultProvider().configure();
        Optional.ofNullable(this.getMessageInterpolator()).ifPresent(arg_0 -> ((Configuration)configuration).messageInterpolator(arg_0));
        this.validatorFactory = configuration.buildValidatorFactory();
    }

    public void validate(Object objectToValidate) {
        Set violations = this.validatorFactory.getValidator().validate(objectToValidate, new Class[0]);
        if (!violations.isEmpty()) {
            String errorMessage = this.composeMessage(violations);
            throw new ConnectorInputException((Throwable)new ValidationException(errorMessage));
        }
    }

    protected MessageInterpolator getMessageInterpolator() {
        try {
            Class.forName("javax.el.ExpressionFactory");
            return null;
        }
        catch (Exception e) {
            try {
                return new ParameterMessageInterpolator();
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    protected String composeMessage(Set<ConstraintViolation<Object>> violations) {
        String firstLine = "Found constraints violated while validating input: \n";
        return firstLine + violations.stream().map(this::buildValidationMessage).collect(Collectors.joining(LF));
    }

    protected String buildValidationMessage(ConstraintViolation<Object> violation) {
        return " - " + violation.getPropertyPath().toString() + ": " + violation.getMessage();
    }
}

