/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.camunda.connector.generator.ConnectorConfig;
import io.camunda.connector.generator.api.DocsGenerator;
import io.camunda.connector.generator.api.DocsGeneratorConfiguration;
import io.camunda.connector.generator.api.GeneratorConfiguration;
import io.camunda.connector.generator.dsl.Doc;
import io.camunda.connector.generator.dsl.ElementTemplate;
import io.camunda.connector.generator.java.ClassBasedDocsGenerator;
import io.camunda.connector.generator.java.ClassBasedTemplateGenerator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-templates", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ElementTemplateGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="connectorClasses", required=true)
    private ConnectorConfig[] connectors;
    @Parameter(property="includeDependencies")
    private String[] includeDependencies;
    @Parameter(property="outputDirectory", defaultValue="${project.basedir}/element-templates")
    private String outputDirectory;
    private static final ObjectWriter objectWriter = new ObjectMapper().writer((PrettyPrinter)new DefaultPrettyPrinter().withObjectIndenter((DefaultPrettyPrinter.Indenter)new DefaultIndenter().withLinefeed("\n")));
    private static final String COMPILED_CLASSES_DIR = "target" + File.separator + "classes";
    private static final String HYBRID_TEMPLATES_DIR = "hybrid";

    public void execute() throws MojoFailureException {
        if (this.connectors.length == 0) {
            this.getLog().warn((CharSequence)"No connector classes specified. Skipping generation of element templates.");
            return;
        }
        ArrayList<URL> classpathUrls = new ArrayList<URL>();
        try {
            String compiledClassesPath = this.project.getFile().getParent() + File.separator + COMPILED_CLASSES_DIR;
            classpathUrls.add(new File(compiledClassesPath).toURI().toURL());
            URL resourcesDirectory = this.getResourcesDirectory();
            URL testResourcesDirectory = this.getTestResourcesDirectory();
            if (resourcesDirectory != null) {
                classpathUrls.add(resourcesDirectory);
            }
            if (testResourcesDirectory != null) {
                classpathUrls.add(testResourcesDirectory);
            }
            for (String dependency : this.includeDependencies) {
                Artifact dependencyArtifact = (Artifact)this.project.getArtifactMap().get(dependency);
                if (dependencyArtifact == null) {
                    throw new IllegalArgumentException("Failed to find dependency " + dependency + " in project " + this.project.getName());
                }
                classpathUrls.add(dependencyArtifact.getFile().toURI().toURL());
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to load classpath: " + e.getMessage(), (Throwable)e);
        }
        try (URLClassLoader classLoader = new URLClassLoader(classpathUrls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());){
            Thread.currentThread().setContextClassLoader(classLoader);
            for (ConnectorConfig connector : this.connectors) {
                this.getLog().info((CharSequence)("Generating element template for " + connector.getConnectorClass()));
                for (ConnectorConfig.FileNameById file : connector.getFiles()) {
                    if (file.getTemplateFileName().endsWith(".json")) continue;
                    throw new IllegalArgumentException("File name must end with .json, but was " + file.getTemplateFileName());
                }
                this.generateElementTemplates(connector, classLoader);
                if (connector.getFiles().stream().filter(fileNameById -> fileNameById.getDocTemplatePath() != null).toList().isEmpty()) continue;
                this.generateDocs(connector, classLoader);
            }
        }
        catch (ClassNotFoundException e) {
            throw new MojoFailureException("Failed to find connector class: " + e.getMessage(), (Throwable)e);
        }
        catch (TypeNotPresentException e) {
            throw new MojoFailureException(e.getMessage() + "\nIf your connector references other packages, include them using the 'includeDependencies' parameter", (Throwable)e);
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to generate element templates: " + e.getMessage(), (Throwable)e);
        }
    }

    private void generateDocs(ConnectorConfig connectorConfig, ClassLoader classLoader) throws ClassNotFoundException {
        ClassBasedDocsGenerator generator = new ClassBasedDocsGenerator(classLoader);
        Class<?> clazz = classLoader.loadClass(connectorConfig.getConnectorClass());
        connectorConfig.getFiles().forEach(arg_0 -> this.lambda$generateDocs$1((DocsGenerator)generator, clazz, arg_0));
    }

    private void generateElementTemplates(ConnectorConfig config, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz = classLoader.loadClass(config.getConnectorClass());
        Map<GeneratorConfiguration.GenerationFeature, Boolean> features = config.getFeatures().entrySet().stream().map(e -> {
            try {
                GeneratorConfiguration.GenerationFeature feature = GeneratorConfiguration.GenerationFeature.valueOf((String)((String)e.getKey()));
                return Map.entry(feature, (Boolean)e.getValue());
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Unknown feature: " + (String)e.getKey() + ". Known features are: " + Arrays.toString(GeneratorConfiguration.GenerationFeature.values()));
            }
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        GeneratorConfiguration generatorConfig = new GeneratorConfiguration(GeneratorConfiguration.ConnectorMode.NORMAL, null, null, null, null, features);
        ClassBasedTemplateGenerator generator = new ClassBasedTemplateGenerator(classLoader);
        List templates = generator.generate(clazz, generatorConfig);
        this.writeElementTemplates(templates, false, config.getFiles());
        if (config.isGenerateHybridTemplates()) {
            GeneratorConfiguration hybridGeneratorConfig = new GeneratorConfiguration(GeneratorConfiguration.ConnectorMode.HYBRID, null, null, null, null, features);
            List hybridTemplates = generator.generate(clazz, hybridGeneratorConfig);
            this.writeElementTemplates(hybridTemplates, true, config.getFiles());
        }
    }

    private void writeElementTemplates(List<ElementTemplate> templates, boolean hybrid, List<ConnectorConfig.FileNameById> fileNames) {
        for (ElementTemplate template : templates) {
            String fileName = this.determineFileName(template, fileNames, hybrid);
            this.writeElementTemplate(template, hybrid, fileName);
        }
    }

    private String determineFileName(ElementTemplate template, List<ConnectorConfig.FileNameById> fileNames, boolean hybrid) {
        String expectedId = hybrid && template.id() != null ? template.id().replace(GeneratorConfiguration.HYBRID_TEMPLATE_ID_SUFFIX, "") : template.id();
        String fileName = fileNames.stream().filter(f -> f.getTemplateId().equals(expectedId)).findFirst().map(ConnectorConfig.FileNameById::getTemplateFileName).orElseGet(() -> {
            this.getLog().warn((CharSequence)("No file name specified for " + expectedId + ". Using default."));
            return this.transformConnectorNameToTemplateFileName(template.name());
        });
        if (hybrid) {
            fileName = fileName.replace(".json", "-hybrid.json");
        }
        return fileName;
    }

    private void writeElementTemplate(ElementTemplate template, boolean hybrid, String fileName) {
        try {
            this.getLog().info((CharSequence)("Writing element template to " + fileName));
            File file = new File(this.outputDirectory, fileName);
            file.getParentFile().mkdirs();
            if (hybrid) {
                file = new File(this.outputDirectory + File.separator + HYBRID_TEMPLATES_DIR, fileName);
                file.getParentFile().mkdirs();
            }
            objectWriter.writeValue(file, (Object)template);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write element template", e);
        }
    }

    private String transformConnectorNameToTemplateFileName(String connectorName) {
        connectorName = connectorName.replaceAll(" ", "-");
        connectorName = connectorName.replaceAll("([a-z])([A-Z]+)", "$1-$2");
        connectorName = connectorName.replaceAll("[^a-zA-Z0-9-]", "");
        connectorName = connectorName.toLowerCase();
        return connectorName + ".json";
    }

    private URL getResourcesDirectory() throws MalformedURLException {
        if (!this.project.getBuild().getResources().isEmpty()) {
            return Path.of(((Resource)this.project.getBuild().getResources().get(0)).getDirectory(), new String[0]).toUri().toURL();
        }
        return null;
    }

    private URL getTestResourcesDirectory() throws MalformedURLException {
        if (!this.project.getBuild().getTestResources().isEmpty()) {
            return Path.of(((Resource)this.project.getBuild().getTestResources().get(0)).getDirectory(), new String[0]).toUri().toURL();
        }
        return null;
    }

    private /* synthetic */ void lambda$generateDocs$1(DocsGenerator generator, Class clazz, ConnectorConfig.FileNameById fileNameById) {
        String templatePath = new File(this.project.getBasedir(), fileNameById.getDocTemplatePath()).getAbsolutePath();
        String templateOutputPath = new File(this.project.getBasedir(), fileNameById.getDocOutputPath()).getAbsolutePath();
        DocsGeneratorConfiguration config = new DocsGeneratorConfiguration(templatePath, templateOutputPath);
        Doc doc = generator.generate((Object)clazz, config);
        try (PrintWriter out = new PrintWriter(config.outputPath());){
            out.println(doc.content());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

