/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.document.store;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import io.camunda.document.api.DocumentCreationRequest;
import io.camunda.document.api.DocumentError;
import io.camunda.document.api.DocumentLink;
import io.camunda.document.api.DocumentMetadataModel;
import io.camunda.document.api.DocumentReference;
import io.camunda.document.api.DocumentStore;
import io.camunda.zeebe.util.Either;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class GcpDocumentStore
implements DocumentStore {
    private final String bucketName;
    private final Storage storage;
    private final ObjectMapper objectMapper;
    private final ExecutorService executor;

    public GcpDocumentStore(String bucketName) {
        this(bucketName, new ObjectMapper(), Executors.newSingleThreadExecutor());
    }

    public GcpDocumentStore(String bucketName, ObjectMapper objectMapper, ExecutorService executor) {
        this.bucketName = bucketName;
        this.storage = (Storage)StorageOptions.getDefaultInstance().getService();
        this.objectMapper = objectMapper;
        this.executor = executor;
    }

    public GcpDocumentStore(String bucketName, Storage storage, ObjectMapper objectMapper, ExecutorService executor) {
        this.bucketName = bucketName;
        this.storage = storage;
        this.objectMapper = objectMapper;
        this.executor = executor;
    }

    public CompletableFuture<Either<DocumentError, DocumentReference>> createDocument(DocumentCreationRequest request) {
        return CompletableFuture.supplyAsync(() -> this.createDocumentInternal(request), this.executor);
    }

    public CompletableFuture<Either<DocumentError, InputStream>> getDocument(String documentId) {
        return CompletableFuture.supplyAsync(() -> this.getDocumentContentInternal(documentId), this.executor);
    }

    public CompletableFuture<Either<DocumentError, Void>> deleteDocument(String documentId) {
        return CompletableFuture.supplyAsync(() -> this.deleteDocumentInternal(documentId), this.executor);
    }

    public CompletableFuture<Either<DocumentError, DocumentLink>> createLink(String documentId, long durationInSeconds) {
        return CompletableFuture.supplyAsync(() -> this.createLinkInternal(documentId, durationInSeconds), this.executor);
    }

    private Either<DocumentError, DocumentReference> createDocumentInternal(DocumentCreationRequest request) {
        Blob existingBlob;
        String documentId = Optional.ofNullable(request.documentId()).orElse(UUID.randomUUID().toString());
        try {
            existingBlob = this.storage.get(this.bucketName, documentId, new Storage.BlobGetOption[0]);
        }
        catch (Exception e) {
            return Either.left((Object)new DocumentError.UnknownDocumentError((Throwable)e));
        }
        if (existingBlob != null) {
            return Either.left((Object)new DocumentError.DocumentAlreadyExists(documentId));
        }
        BlobId blobId = BlobId.of((String)this.bucketName, (String)documentId);
        BlobInfo.Builder blobInfoBuilder = BlobInfo.newBuilder((BlobId)blobId);
        try {
            this.applyMetadata(blobInfoBuilder, request.metadata());
        }
        catch (JsonProcessingException e) {
            return Either.left((Object)new DocumentError.InvalidInput("Failed to serialize metadata: " + e.getMessage()));
        }
        try {
            this.storage.createFrom(blobInfoBuilder.build(), request.contentInputStream(), new Storage.BlobWriteOption[0]);
        }
        catch (Exception e) {
            return Either.left((Object)new DocumentError.UnknownDocumentError((Throwable)e));
        }
        DocumentReference documentReference = new DocumentReference(documentId, request.metadata());
        return Either.right((Object)documentReference);
    }

    private Either<DocumentError, InputStream> getDocumentContentInternal(String documentId) {
        try {
            Blob blob = this.storage.get(this.bucketName, documentId, new Storage.BlobGetOption[0]);
            if (blob == null) {
                return Either.left((Object)new DocumentError.DocumentNotFound(documentId));
            }
            InputStream inputStream = Channels.newInputStream((ReadableByteChannel)blob.reader(new Blob.BlobSourceOption[0]));
            return Either.right((Object)inputStream);
        }
        catch (Exception e) {
            return Either.left((Object)new DocumentError.UnknownDocumentError((Throwable)e));
        }
    }

    private Either<DocumentError, Void> deleteDocumentInternal(String documentId) {
        try {
            boolean result = this.storage.delete(this.bucketName, documentId, new Storage.BlobSourceOption[0]);
            if (!result) {
                return Either.left((Object)new DocumentError.DocumentNotFound(documentId));
            }
            return Either.right(null);
        }
        catch (Exception e) {
            return Either.left((Object)new DocumentError.UnknownDocumentError((Throwable)e));
        }
    }

    private Either<DocumentError, DocumentLink> createLinkInternal(String documentId, long durationInSeconds) {
        try {
            Blob blob = this.storage.get(this.bucketName, documentId, new Storage.BlobGetOption[0]);
            if (blob == null) {
                return Either.left((Object)new DocumentError.DocumentNotFound(documentId));
            }
            URL link = blob.signUrl(durationInSeconds, TimeUnit.SECONDS, new Storage.SignUrlOption[0]);
            return Either.right((Object)new DocumentLink(link.toString(), ZonedDateTime.now().plusSeconds(durationInSeconds)));
        }
        catch (Exception e) {
            return Either.left((Object)new DocumentError.UnknownDocumentError((Throwable)e));
        }
    }

    private void applyMetadata(BlobInfo.Builder blobInfoBuilder, DocumentMetadataModel metadata) throws JsonProcessingException {
        if (metadata == null) {
            return;
        }
        if (metadata.contentType() != null && !metadata.contentType().isEmpty()) {
            blobInfoBuilder.setContentType(metadata.contentType());
        }
        if (metadata.expiresAt() != null) {
            blobInfoBuilder.setCustomTimeOffsetDateTime(OffsetDateTime.from(metadata.expiresAt()));
        }
        if (metadata.fileName() != null && !metadata.fileName().isEmpty()) {
            blobInfoBuilder.setContentDisposition("attachment; filename=" + metadata.fileName());
        } else {
            blobInfoBuilder.setContentDisposition("attachment");
        }
        if (metadata.additionalProperties() != null && !metadata.additionalProperties().isEmpty()) {
            HashMap blobMetadata = new HashMap();
            String valueAsString = this.objectMapper.writeValueAsString((Object)metadata.additionalProperties());
            metadata.additionalProperties().forEach((key, value) -> blobMetadata.put(key, valueAsString));
            blobInfoBuilder.setMetadata(blobMetadata);
        }
    }
}

