/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.identity.sdk.authentication;

import com.auth0.jwk.InvalidPublicKeyException;
import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.AlgorithmMismatchException;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.authentication.AccessToken;
import io.camunda.identity.sdk.authentication.Authentication;
import io.camunda.identity.sdk.authentication.Tokens;
import io.camunda.identity.sdk.authentication.UserDetails;
import io.camunda.identity.sdk.authentication.exception.InvalidClaimException;
import io.camunda.identity.sdk.authentication.exception.InvalidSignatureException;
import io.camunda.identity.sdk.authentication.exception.JsonWebKeyException;
import io.camunda.identity.sdk.authentication.exception.TokenDecodeException;
import io.camunda.identity.sdk.authentication.exception.TokenExpiredException;
import io.camunda.identity.sdk.authentication.exception.TokenVerificationException;
import io.camunda.identity.sdk.cache.ClientTokenCache;
import io.camunda.identity.sdk.impl.dto.WellKnownConfiguration;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ehcache.Cache;

public abstract class AbstractAuthentication
implements Authentication {
    public static final long JWKS_CACHE_SIZE = 5L;
    public static final long JWKS_CACHE_LIFETIME_DAYS = 7L;
    public static final String WELL_KNOWN_PATH = "/.well-known/openid-configuration";
    protected final IdentityConfiguration configuration;
    protected final Cache<String, Tokens> tokenCache = new ClientTokenCache().getCache();

    protected AbstractAuthentication(IdentityConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public boolean isAvailable() {
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.configuration.getIssuer(), this.configuration.getIssuerBackendUrl(), this.configuration.getClientId(), this.configuration.getClientSecret()});
    }

    @Override
    public Tokens requestToken(String audience) {
        if (!this.tokenCache.containsKey((Object)audience)) {
            this.tokenCache.put((Object)audience, (Object)this.requestFreshToken(audience));
        }
        return (Tokens)this.tokenCache.get((Object)audience);
    }

    @Override
    public DecodedJWT decodeJWT(String token) {
        try {
            return JWT.decode((String)token);
        }
        catch (JWTDecodeException e) {
            throw new TokenDecodeException(e);
        }
    }

    @Override
    public AccessToken verifyTokenIgnoringAudience(String token) {
        return this.verifyToken(token, null);
    }

    @Override
    public AccessToken verifyToken(String token) {
        return this.verifyToken(token, this.configuration.getAudience());
    }

    protected AccessToken verifyToken(String token, String audience) {
        try {
            DecodedJWT jwt = this.verify(this.decodeJWT(token), audience);
            return new AccessToken(jwt, this.getPermissions(jwt, audience), this.getAssignedOrganizations(jwt), this.getUserDetails(jwt));
        }
        catch (AlgorithmMismatchException | SignatureVerificationException e) {
            throw new InvalidSignatureException(e);
        }
        catch (com.auth0.jwt.exceptions.TokenExpiredException e) {
            throw new TokenExpiredException(e);
        }
        catch (com.auth0.jwt.exceptions.InvalidClaimException e) {
            throw new InvalidClaimException(e);
        }
    }

    protected UserDetails getUserDetails(DecodedJWT token) {
        return new UserDetails(token.getSubject(), token.getClaim("email").asString(), token.getClaim("preferred_username").asString(), token.getClaim("name").asString(), this.getGroups(token));
    }

    private DecodedJWT verify(DecodedJWT token, String audience) {
        try {
            Jwk jwk = this.jwkProvider().get(token.getKeyId());
            this.verifyJwk(token, jwk);
            Algorithm algorithm = this.signatureValidationAlgorithm(jwk);
            JWTVerifier tokenVerifier = audience != null ? JWT.require((Algorithm)algorithm).withAudience(new String[]{audience}).build() : JWT.require((Algorithm)algorithm).build();
            return tokenVerifier.verify(token);
        }
        catch (JwkException e) {
            throw new JsonWebKeyException("JWKS error", e);
        }
    }

    private void verifyJwk(DecodedJWT token, Jwk jwk) {
        if (jwk.getUsage() != null && !jwk.getUsage().equals("sig")) {
            throw new TokenVerificationException("Token is signed with a JWK, that can not be used for signing");
        }
        if (jwk.getAlgorithm() != null && !jwk.getAlgorithm().equals(token.getAlgorithm())) {
            throw new TokenVerificationException("JWT algorithm does not match JWK algorithm");
        }
    }

    private Algorithm signatureValidationAlgorithm(Jwk jwk) throws InvalidPublicKeyException {
        if (jwk.getAlgorithm() == null || jwk.getAlgorithm().equals("RS256")) {
            return Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)jwk.getPublicKey()), null);
        }
        switch (jwk.getAlgorithm()) {
            case "RS384": {
                return Algorithm.RSA384((RSAPublicKey)((RSAPublicKey)jwk.getPublicKey()), null);
            }
            case "RS512": {
                return Algorithm.RSA512((RSAPublicKey)((RSAPublicKey)jwk.getPublicKey()), null);
            }
            case "ES256": {
                return Algorithm.ECDSA256((ECPublicKey)((ECPublicKey)jwk.getPublicKey()), null);
            }
            case "ES384": {
                return Algorithm.ECDSA384((ECPublicKey)((ECPublicKey)jwk.getPublicKey()), null);
            }
            case "ES512": {
                return Algorithm.ECDSA512((ECPublicKey)((ECPublicKey)jwk.getPublicKey()), null);
            }
        }
        throw new TokenVerificationException(String.format("Signing algorithm '%s' is not supported", jwk.getAlgorithm()));
    }

    protected abstract List<String> getPermissions(DecodedJWT var1, String var2);

    protected abstract List<String> getGroups(DecodedJWT var1);

    protected abstract Map<String, Set<String>> getAssignedOrganizations(DecodedJWT var1);

    protected abstract JwkProvider jwkProvider();

    protected abstract WellKnownConfiguration wellKnownConfiguration();

    protected abstract Tokens requestFreshToken(String var1);
}

