/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.identity.sdk.impl.auth0.authentication;

import com.auth0.client.auth.AuthAPI;
import com.auth0.exception.Auth0Exception;
import com.auth0.json.auth.TokenHolder;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.JwkProviderBuilder;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.net.Request;
import com.auth0.net.TokenRequest;
import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.authentication.AbstractAuthentication;
import io.camunda.identity.sdk.authentication.AuthorizeUriBuilder;
import io.camunda.identity.sdk.authentication.Tokens;
import io.camunda.identity.sdk.authentication.dto.AuthCodeDto;
import io.camunda.identity.sdk.authentication.dto.OrganizationDto;
import io.camunda.identity.sdk.authentication.exception.CodeExchangeException;
import io.camunda.identity.sdk.exception.IdentityException;
import io.camunda.identity.sdk.impl.auth0.authentication.Auth0AuthorizeUriBuilder;
import io.camunda.identity.sdk.impl.dto.WellKnownConfiguration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.Validate;

public class Auth0Authentication
extends AbstractAuthentication {
    private AuthAPI authApi;
    private JwkProvider jwkProvider;

    public Auth0Authentication(IdentityConfiguration configuration) {
        super(configuration);
    }

    private AuthAPI authApi() {
        if (this.authApi == null) {
            this.authApi = new AuthAPI(this.configuration.getIssuer(), this.configuration.getClientId(), this.configuration.getClientSecret());
        }
        return this.authApi;
    }

    @Override
    public AuthorizeUriBuilder authorizeUriBuilder(String redirectUri) {
        return new Auth0AuthorizeUriBuilder(this.configuration, this.authApi(), redirectUri);
    }

    @Override
    public Tokens exchangeAuthCode(AuthCodeDto authCodeDto, String redirectUri) throws CodeExchangeException {
        Validate.notNull((Object)authCodeDto, (String)"authCodeDto must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)redirectUri, (String)"redirectUri must not be null", (Object[])new Object[0]);
        if (authCodeDto.getError() != null && !authCodeDto.getError().isBlank()) {
            throw new CodeExchangeException(authCodeDto.getError());
        }
        TokenRequest request = this.authApi().exchangeCode(authCodeDto.getCode(), redirectUri).setAudience(this.configuration.getAudience());
        try {
            TokenHolder tokenHolder = (TokenHolder)request.execute();
            return this.fromTokenHolder(tokenHolder);
        }
        catch (Auth0Exception exception) {
            throw new CodeExchangeException("Auth0 Code exchange failed", exception);
        }
    }

    @Override
    protected Tokens requestFreshToken(String audience) {
        TokenRequest request = this.authApi().requestToken(audience);
        try {
            TokenHolder tokenHolder = (TokenHolder)request.execute();
            return this.fromTokenHolder(tokenHolder);
        }
        catch (Auth0Exception exception) {
            throw new IdentityException("Auth0 token request failed", exception);
        }
    }

    @Override
    public Tokens renewToken(String refreshToken) {
        Validate.notEmpty((CharSequence)refreshToken, (String)"refreshToken can not be empty", (Object[])new Object[0]);
        TokenRequest request = this.authApi().renewAuth(refreshToken);
        try {
            TokenHolder tokenHolder = (TokenHolder)request.execute();
            return this.fromTokenHolder(tokenHolder);
        }
        catch (Auth0Exception exception) {
            throw new IdentityException("Auth0 refresh failed", exception);
        }
    }

    @Override
    public void revokeToken(String refreshToken) {
        Request request = this.authApi().revokeToken(refreshToken);
        try {
            request.execute();
        }
        catch (Auth0Exception exception) {
            throw new IdentityException("Auth0 token revocation failed", exception);
        }
    }

    @Override
    public boolean isM2MToken(String token) {
        DecodedJWT decodedJwt = this.decodeJWT(token);
        Claim subClaim = decodedJwt.getClaim("sub");
        return subClaim.asString().contains("@clients");
    }

    @Override
    public String getClientId(String token) {
        DecodedJWT decodedJwt = this.decodeJWT(token);
        return decodedJwt.getClaim("azp").asString();
    }

    @Override
    protected List<String> getPermissions(DecodedJWT token, String audience) {
        Claim permissionsClaim = token.getClaim("permissions");
        if (permissionsClaim.isMissing()) {
            return Collections.emptyList();
        }
        return permissionsClaim.asList(String.class);
    }

    @Override
    protected List<String> getGroups(DecodedJWT token) {
        return Collections.emptyList();
    }

    @Override
    protected Map<String, Set<String>> getAssignedOrganizations(DecodedJWT token) {
        Claim orgClaim = token.getClaim("https://camunda.com/orgs");
        if (orgClaim.isMissing()) {
            return Collections.emptyMap();
        }
        return orgClaim.asList(OrganizationDto.class).stream().collect(Collectors.toMap(OrganizationDto::getId, OrganizationDto::getRoles));
    }

    @Override
    protected JwkProvider jwkProvider() {
        if (this.jwkProvider == null) {
            this.jwkProvider = new JwkProviderBuilder(this.configuration.getIssuer()).cached(5L, 7L, TimeUnit.DAYS).build();
        }
        return this.jwkProvider;
    }

    @Override
    protected WellKnownConfiguration wellKnownConfiguration() {
        throw new NotImplementedException();
    }

    private Tokens fromTokenHolder(TokenHolder tokenHolder) {
        return new Tokens(tokenHolder.getAccessToken(), tokenHolder.getRefreshToken(), tokenHolder.getExpiresIn(), tokenHolder.getScope(), tokenHolder.getTokenType());
    }
}

