/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.identity.sdk.impl.microsoft;

import com.auth0.jwt.interfaces.DecodedJWT;
import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.authentication.AuthorizeUriBuilder;
import io.camunda.identity.sdk.authentication.UserDetails;
import io.camunda.identity.sdk.impl.generic.GenericAuthentication;
import io.camunda.identity.sdk.impl.microsoft.MicrosoftAuthorizeUriBuilder;
import io.camunda.identity.sdk.impl.rest.RestClient;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;

public class MicrosoftAuthentication
extends GenericAuthentication {
    public MicrosoftAuthentication(IdentityConfiguration configuration, RestClient restClient) {
        super(configuration, restClient);
    }

    @Override
    public AuthorizeUriBuilder authorizeUriBuilder(String redirectUri) {
        return new MicrosoftAuthorizeUriBuilder(this.configuration, this.wellKnownConfiguration().getAuthorizationEndpoint(), redirectUri);
    }

    @Override
    public void revokeToken(String refreshToken) {
        throw new NotImplementedException("Revoke token is not supported.");
    }

    @Override
    public List<String> getPermissions(DecodedJWT token, String audience) {
        return List.of("read:*", "write:*");
    }

    @Override
    public boolean isM2MToken(String token) {
        DecodedJWT decodedJwt = this.decodeJWT(token);
        return decodedJwt.getClaim("email").isMissing();
    }

    @Override
    public String getClientId(String token) {
        DecodedJWT decodedJwt = this.decodeJWT(token);
        return decodedJwt.getClaim("appid").asString();
    }

    @Override
    protected List<String> getGroups(DecodedJWT token) {
        return Collections.emptyList();
    }

    @Override
    protected UserDetails getUserDetails(DecodedJWT token) {
        return new UserDetails(token.getSubject(), token.getClaim("email").asString(), token.getClaim("unique_name").asString(), token.getClaim("name").asString(), this.getGroups(token));
    }
}

