/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.sdk.cache;

import io.camunda.identity.sdk.authentication.Tokens;
import org.ehcache.Cache;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;

public class ClientTokenCache {
  private final Cache<String, Tokens> cache;

  public ClientTokenCache() {
    this.cache = CacheManagerBuilder.newCacheManagerBuilder()
        .withCache("tokenCache",
            CacheConfigurationBuilder.newCacheConfigurationBuilder(
                    String.class, Tokens.class,
                    ResourcePoolsBuilder.heap(10)
                )
                .withExpiry(new ClientTokenCacheExpiryPolicy())
        )
        .build(true)
        .getCache("tokenCache", String.class, Tokens.class);
  }

  public Cache<String, Tokens> getCache() {
    return cache;
  }
}
