/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.sdk.impl.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class RequestClientTokenDto {
  private final String clientId;
  private final String clientSecret;
  private final String audience;
  private final String scope;
  private final String grantType;

  public RequestClientTokenDto(
      final String clientId,
      final String clientSecret,
      final String audience,
      final String scope
  ) {
    this.clientId = clientId;
    this.clientSecret = clientSecret;
    this.audience = audience;
    this.scope = Objects.requireNonNullElse(scope, "openid");
    grantType = "client_credentials";
  }

  @JsonProperty("client_id")
  public String getClientId() {
    return clientId;
  }

  @JsonProperty("client_secret")
  public String getClientSecret() {
    return clientSecret;
  }

  @JsonProperty("audience")
  public String getAudience() {
    return audience;
  }

  @JsonProperty("grant_type")
  public String getGrantType() {
    return grantType;
  }

  @JsonProperty("scope")
  public String getScope() {
    return scope;
  }
}
