/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.sdk.impl.microsoft;

import com.auth0.jwt.interfaces.DecodedJWT;
import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.authentication.AuthorizeUriBuilder;
import io.camunda.identity.sdk.authentication.UserDetails;
import io.camunda.identity.sdk.impl.generic.GenericAuthentication;
import io.camunda.identity.sdk.impl.rest.RestClient;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;

public class MicrosoftAuthentication extends GenericAuthentication {

  public MicrosoftAuthentication(
      final IdentityConfiguration configuration,
      final RestClient restClient
  ) {
    super(configuration, restClient);
  }

  @Override
  public AuthorizeUriBuilder authorizeUriBuilder(final String redirectUri) {
    return new MicrosoftAuthorizeUriBuilder(
        configuration,
        wellKnownConfiguration().getAuthorizationEndpoint(),
        redirectUri
    );
  }

  @Override
  public void revokeToken(final String refreshToken) {
    throw new NotImplementedException("Revoke token is not supported.");
  }

  @Override
  public List<String> getPermissions(final DecodedJWT token, final String audience) {
    // TODO: implement retrieval of permissions from a specific claim when using Azure AD
    return List.of(
        "read:*",
        "write:*"
    );
  }

  @Override
  public boolean isM2MToken(final String token) {
    final DecodedJWT decodedJwt = decodeJWT(token);

    return decodedJwt.getClaim("email").isMissing();
  }

  @Override
  public String getClientId(final String token) {
    final DecodedJWT decodedJwt = decodeJWT(token);

    return decodedJwt.getClaim("appid").asString();
  }

  @Override
  protected List<String> getGroups(final DecodedJWT token) {
    return Collections.emptyList();
  }

  @Override
  protected UserDetails getUserDetails(final DecodedJWT token) {
    return new UserDetails(
        token.getSubject(),
        token.getClaim("email").asString(),
        token.getClaim("unique_name").asString(),
        token.getClaim("name").asString(),
        getGroups(token)
    );
  }
}
