/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */

package io.camunda.identity.sdk.impl.rest.request;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.Map;

public abstract class Request<T> {
  final String url;
  final TypeReference<T> typeReference;
  String authentication;
  Map<String, String> params = new HashMap<>();
  Object body;
  ContentType contentType = ContentType.X_WWW_URL_ENCODED;
  HttpMethod httpMethod;

  public Request(final String url, final TypeReference<T> typeReference) {
    this.url = url;
    this.typeReference = typeReference;
  }

  public String getUrl() {
    return url;
  }

  public String getAuthentication() {
    return authentication;
  }

  public void setAuthentication(
      final String authentication
  ) {
    this.authentication = authentication;
  }

  public Map<String, String> getParams() {
    return params;
  }

  public void setParams(final Map<String, String> params) {
    this.params = params;
  }

  public Object getBody() {
    return body;
  }

  public void setBody(final Object body) {
    this.body = body;
  }

  public ContentType getContentType() {
    return contentType;
  }

  public void setContentType(final ContentType contentType) {
    this.contentType = contentType;
  }

  public HttpMethod getHttpMethod() {
    return httpMethod;
  }

  public void setHttpMethod(final HttpMethod httpMethod) {
    this.httpMethod = httpMethod;
  }

  public TypeReference<T> getTypeReference() {
    return typeReference;
  }

  public enum ContentType {
    JSON("application/json"),
    X_WWW_URL_ENCODED("application/x-www-form-urlencoded");

    private final String value;

    ContentType(final String value) {
      this.value = value;
    }

    @Override
    public String toString() {
      return value;
    }
  }

  public enum HttpMethod {
    PUT
  }
}
