/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */

package io.camunda.identity.sdk.impl.rest.request;

import com.fasterxml.jackson.core.type.TypeReference;
import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.impl.dto.RevokeTokenDto;

public class RevokeTokenRequest extends Request<Void> {
  public RevokeTokenRequest(
      final IdentityConfiguration configuration,
      final String url,
      final String refreshToken
  ) {
    super(url, new TypeReference<>() {});
    this.body =
        new RevokeTokenDto(configuration.getClientId(),
                           configuration.getClientSecret(),
                           refreshToken
        );
  }
}
