/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */

package io.camunda.identity.sdk.impl.rest.request;

import static io.camunda.identity.sdk.impl.UsersImpl.USERS_PATH;
import static io.camunda.identity.sdk.utility.UrlUtility.combinePaths;

import com.fasterxml.jackson.core.type.TypeReference;
import io.camunda.identity.sdk.users.dto.User;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UsersRequest extends Request<List<User>> {
  public UsersRequest(
      final String baseUrl,
      final String authentication,
      final List<String> userIds
  ) {
    this(baseUrl, authentication, null, null, null, userIds);
  }

  public UsersRequest(
      final String baseUrl,
      final String authentication,
      final String search,
      final Integer page,
      final Integer resultSize
  ) {
    this(baseUrl, authentication, search, page, resultSize, null);
  }

  private UsersRequest(
      final String baseUrl,
      final String authentication,
      final String search,
      final Integer page,
      final Integer resultSize,
      final List<String> userIds
  ) {
    super(combinePaths(baseUrl, USERS_PATH), new TypeReference<>() {
    });

    final Map<String, String> params = buildParamMap(search, page, resultSize, userIds);

    this.setAuthentication(authentication);
    this.setParams(params);
  }

  private Map<String, String> buildParamMap(
      final String search,
      final Integer page,
      final Integer resultSize,
      final List<String> userIds
  ) {
    final Map<String, String> params = new HashMap<>();

    if (search != null) {
      params.put("search", search);
    }

    if (page != null) {
      params.put("page", String.valueOf(page));
    }

    if (resultSize != null) {
      params.put("resultSize", String.valueOf(resultSize));
    }

    if (userIds != null) {
      params.put("userIds", String.join(",", userIds));
    }

    return params;
  }
}
