/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.sdk.impl;

import static io.camunda.identity.sdk.utility.UrlUtility.combinePaths;

import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.impl.rest.RestClient;
import io.camunda.identity.sdk.impl.rest.request.TenantRequest;
import io.camunda.identity.sdk.tenants.Tenants;
import io.camunda.identity.sdk.tenants.dto.Tenant;
import java.util.List;

public class TenantsImpl implements Tenants {
  static final String TENANTS_PATH = "/api/tenants";
  static final String FOR_TOKEN_PATH = "/for-token";

  private final String baseUrl;
  private final RestClient restClient;

  public TenantsImpl(
      final IdentityConfiguration identityConfiguration
  ) {
    this(identityConfiguration.getBaseUrl());
  }

  private TenantsImpl(final String baseUrl) {
    this.baseUrl = baseUrl;
    this.restClient = new RestClient();
  }

  @Override
  public List<Tenant> forToken(final String token) {
    return restClient.request(
        new TenantRequest(
            combinePaths(baseUrl, TENANTS_PATH, FOR_TOKEN_PATH),
            token
        )
    );
  }
}
