/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.sdk.impl.dto;

import com.fasterxml.jackson.annotation.JsonProperty;

public class ExchangeAuthCodeDto {
  private final String clientId;
  private final String clientSecret;
  private final String redirectUri;
  private final String code;

  public ExchangeAuthCodeDto(final String clientId, final String clientSecret,
                             final String redirectUri, final String code) {
    this.clientId = clientId;
    this.clientSecret = clientSecret;
    this.redirectUri = redirectUri;
    this.code = code;
  }

  @JsonProperty("client_id")
  public String getClientId() {
    return clientId;
  }

  @JsonProperty("client_secret")
  public String getClientSecret() {
    return clientSecret;
  }

  @JsonProperty("redirect_uri")
  public String getRedirectUri() {
    return redirectUri;
  }

  @JsonProperty("grant_type")
  public String getGrantType() {
    return "authorization_code";
  }

  @JsonProperty("code")
  public String getCode() {
    return code;
  }
}
