/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.sdk.impl.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class WellKnownConfiguration {
  private final String jwksUri;
  private final String authorizationEndpoint;
  private final String tokenEndpoint;
  private final String endSessionEndpoint;
  private final String revocationEndpoint;
  private final boolean frontChannelLogoutSupported;

  public WellKnownConfiguration(
      @JsonProperty("jwks_uri") final String jwksUri,
      @JsonProperty("authorization_endpoint") final String authorizationEndpoint,
      @JsonProperty("token_endpoint") final String tokenEndpoint,
      @JsonProperty("end_session_endpoint") final String endSessionEndpoint,
      @JsonProperty("revocation_endpoint") final String revocationEndpoint,
      @JsonProperty("frontchannel_logout_supported") final String frontChannelLogoutSupported
  ) {
    this.jwksUri = jwksUri;
    this.authorizationEndpoint = authorizationEndpoint;
    this.tokenEndpoint = tokenEndpoint;
    this.endSessionEndpoint = endSessionEndpoint;
    this.revocationEndpoint = revocationEndpoint;
    this.frontChannelLogoutSupported = Boolean.parseBoolean(frontChannelLogoutSupported);
  }

  public String getJwksUri() {
    return jwksUri;
  }

  public String getAuthorizationEndpoint() {
    return authorizationEndpoint;
  }

  public String getTokenEndpoint() {
    return tokenEndpoint;
  }

  public String getEndSessionEndpoint() {
    return endSessionEndpoint;
  }

  public String getRevocationEndpoint() {
    return revocationEndpoint;
  }

  public boolean isFrontChannelLogoutSupported() {
    return frontChannelLogoutSupported;
  }
}
