/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.sdk.tenants;

import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.annotation.AnnotationProcessor;
import io.camunda.identity.sdk.annotation.RequiresBaseUrl;
import io.camunda.identity.sdk.impl.TenantsImpl;
import io.camunda.identity.sdk.tenants.dto.Tenant;
import java.util.List;

public interface Tenants {
  /**
   * Returns the list of tenants which are assigned to the user linked to the token.
   *
   * @param token the token
   * @return the list of tenants
   */
  @RequiresBaseUrl
  List<Tenant> forToken(final String token);

  /**
   * Factory function to create a new tenants instance
   *
   * @param configuration  Identity configuration
   * @return Tenants instance
   */
  static Tenants create(
      final IdentityConfiguration configuration
  ) {
    return AnnotationProcessor.apply(configuration, Tenants.class,
        new TenantsImpl(configuration));
  }
}
