/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.sdk.authorizations.dto;

public class AssignAuthorization {
  private final String entityId;
  private final String entityType;
  private final String organizationId;
  private final String resourceKey;
  private final String resourceType;
  private final String permission;

  public AssignAuthorization(
      final String entityId,
      final String entityType,
      final String organizationId,
      final String resourceKey,
      final String resourceType,
      final String permission
  ) {
    this.entityId = entityId;
    this.entityType = entityType;
    this.organizationId = organizationId;
    this.resourceKey = resourceKey;
    this.resourceType = resourceType;
    this.permission = permission;
  }

  public String getEntityId() {
    return entityId;
  }

  public String getEntityType() {
    return entityType;
  }

  public String getOrganizationId() {
    return organizationId;
  }

  public String getResourceKey() {
    return resourceKey;
  }

  public String getResourceType() {
    return resourceType;
  }

  public String getPermission() {
    return permission;
  }
}
