/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.sdk.impl.dto;

import com.fasterxml.jackson.annotation.JsonProperty;

public class AccessTokenDto {
  private final String accessToken;
  private final String refreshToken;
  private final String idToken;
  private final long expiresIn;
  private final String scope;
  private final String tokenType;

  public AccessTokenDto(@JsonProperty("access_token") final String accessToken,
                        @JsonProperty("refresh_token") final String refreshToken,
                        @JsonProperty("id_token") final String idToken,
                        @JsonProperty("expires_in") final long expiresIn,
                        @JsonProperty("scope") final String scope,
                        @JsonProperty("token_type") final String tokenType) {
    this.accessToken = accessToken;
    this.refreshToken = refreshToken;
    this.idToken = idToken;
    this.expiresIn = expiresIn;
    this.scope = scope;
    this.tokenType = tokenType;
  }

  public String getAccessToken() {
    return accessToken;
  }

  public String getRefreshToken() {
    return refreshToken;
  }

  public String getIdToken() {
    return idToken;
  }

  public long getExpiresIn() {
    return expiresIn;
  }

  public String getScope() {
    return scope;
  }

  public String getTokenType() {
    return tokenType;
  }
}
