/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.sdk.impl.microsoft;

import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.impl.generic.GenericAuthorizeUriBuilder;

public class MicrosoftAuthorizeUriBuilder extends GenericAuthorizeUriBuilder {

  MicrosoftAuthorizeUriBuilder(
      final IdentityConfiguration configuration,
      final String authorizeEndpoint,
      final String redirectUri
  ) {
    super(configuration, authorizeEndpoint, redirectUri);
  }

  @Override
  protected String buildScopes() {
    return String.format("openid email offline_access %s/.default", configuration.getAudience());
  }
}
