/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.identity.sdk.impl;

import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.authorizations.Authorizations;
import io.camunda.identity.sdk.authorizations.dto.AssignAuthorization;
import io.camunda.identity.sdk.authorizations.dto.Authorization;
import io.camunda.identity.sdk.authorizations.dto.UpdateAuthorizations;
import io.camunda.identity.sdk.impl.rest.RestClient;
import io.camunda.identity.sdk.impl.rest.request.AssignAuthorizationRequest;
import io.camunda.identity.sdk.impl.rest.request.AuthorizationRequest;
import io.camunda.identity.sdk.impl.rest.request.UpdateAuthorizationsRequest;
import io.camunda.identity.sdk.utility.UrlUtility;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AuthorizationsImpl
implements Authorizations {
    static final String AUTHORIZATIONS_PATH = "/api/authorizations";
    static final String FOR_TOKEN_PATH = "/for-token";
    private final String baseUrl;
    private final RestClient restClient;

    public AuthorizationsImpl(IdentityConfiguration identityConfiguration) {
        this(identityConfiguration.getBaseUrl());
    }

    private AuthorizationsImpl(String baseUrl) {
        this.baseUrl = baseUrl;
        this.restClient = new RestClient();
    }

    @Override
    public List<Authorization> forToken(String token) {
        return this.restClient.request(new AuthorizationRequest(UrlUtility.combinePaths(this.baseUrl, AUTHORIZATIONS_PATH, FOR_TOKEN_PATH), token, Collections.emptyMap()));
    }

    @Override
    public List<Authorization> forToken(String token, String organizationId) {
        return this.restClient.request(new AuthorizationRequest(UrlUtility.combinePaths(this.baseUrl, AUTHORIZATIONS_PATH, FOR_TOKEN_PATH), token, Map.of("organizationId", organizationId)));
    }

    @Override
    public void assignAuthorization(String token, String entityId, String entityType, String organizationId, String resourceKey, String resourceType, Set<String> requestedPermissions) {
        requestedPermissions.forEach(permission -> this.restClient.request(new AssignAuthorizationRequest(UrlUtility.combinePaths(this.baseUrl, AUTHORIZATIONS_PATH), token, new AssignAuthorization(entityId, entityType, organizationId, resourceKey, resourceType, (String)permission))));
    }

    @Override
    public void update(String token, UpdateAuthorizations updateAuthorizations) {
        this.restClient.request(new UpdateAuthorizationsRequest(UrlUtility.combinePaths(this.baseUrl, AUTHORIZATIONS_PATH), token, updateAuthorizations));
    }
}

