/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.identity.sdk.authentication;

import com.auth0.jwk.InvalidPublicKeyException;
import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.AlgorithmMismatchException;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.authentication.AccessToken;
import io.camunda.identity.sdk.authentication.Authentication;
import io.camunda.identity.sdk.authentication.SingleSignOutUriBuilder;
import io.camunda.identity.sdk.authentication.Tokens;
import io.camunda.identity.sdk.authentication.UserDetails;
import io.camunda.identity.sdk.authentication.exception.InvalidClaimException;
import io.camunda.identity.sdk.authentication.exception.InvalidSignatureException;
import io.camunda.identity.sdk.authentication.exception.JsonWebKeyException;
import io.camunda.identity.sdk.authentication.exception.TokenDecodeException;
import io.camunda.identity.sdk.authentication.exception.TokenExpiredException;
import io.camunda.identity.sdk.authentication.exception.TokenVerificationException;
import io.camunda.identity.sdk.cache.ClientTokenCache;
import io.camunda.identity.sdk.impl.GenericSingleSignOutBuilder;
import io.camunda.identity.sdk.impl.dto.WellKnownConfiguration;
import io.camunda.identity.sdk.impl.rest.RestClient;
import io.camunda.identity.sdk.impl.rest.request.GroupRequest;
import io.camunda.identity.sdk.utility.UrlUtility;
import java.net.URI;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.ehcache.Cache;

public abstract class AbstractAuthentication
implements Authentication {
    public static final long JWKS_CACHE_SIZE = 5L;
    public static final long JWKS_CACHE_LIFETIME_DAYS = 7L;
    public static final String WELL_KNOWN_PATH = "/.well-known/openid-configuration";
    static final String GROUPS_PATH = "/api/groups";
    static final String FOR_TOKEN_PATH = "/for-token";
    protected final IdentityConfiguration configuration;
    protected final Cache<String, Tokens> tokenCache = new ClientTokenCache().getCache();
    protected final RestClient restClient;

    protected AbstractAuthentication(IdentityConfiguration configuration, RestClient restClient) {
        this.configuration = configuration;
        this.restClient = restClient;
    }

    @Override
    public boolean isAvailable() {
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.configuration.getIssuer(), this.configuration.getIssuerBackendUrl(), this.configuration.getClientId(), this.configuration.getClientSecret()});
    }

    @Override
    public Tokens requestToken(String audience) {
        if (!this.tokenCache.containsKey((Object)audience)) {
            this.tokenCache.put((Object)audience, (Object)this.requestFreshToken(audience));
        }
        return (Tokens)this.tokenCache.get((Object)audience);
    }

    @Override
    public DecodedJWT decodeJWT(String token) {
        try {
            return JWT.decode((String)token);
        }
        catch (JWTDecodeException e) {
            throw new TokenDecodeException(e);
        }
    }

    @Override
    public AccessToken verifyTokenIgnoringAudience(String token) {
        return this.verifyToken(token, null, null);
    }

    @Override
    public Optional<URI> singleSignOut(String refreshToken, String callbackUrl) {
        if (this.isRevokeAvailable() && StringUtils.isNotBlank((CharSequence)refreshToken)) {
            this.revokeToken(refreshToken);
            return Optional.empty();
        }
        if (this.isSingleSignOutAvailable()) {
            return Optional.of(this.generateSingleSignOutUri(callbackUrl));
        }
        throw new NotImplementedException("single sign out is not implemented for this case");
    }

    @Override
    public AccessToken verifyToken(String token) {
        return this.verifyToken(token, this.configuration.getAudience(), null);
    }

    @Override
    public AccessToken verifyToken(String token, String organizationId) {
        return this.verifyToken(token, this.configuration.getAudience(), organizationId);
    }

    protected AccessToken verifyToken(String token, String audience, String organizationId) {
        try {
            DecodedJWT jwt = this.verifyAndDecode(token, audience);
            return new AccessToken(jwt, this.getPermissions(jwt, audience), this.getAssignedOrganizations(jwt), this.getUserDetails(jwt, organizationId));
        }
        catch (AlgorithmMismatchException | SignatureVerificationException e) {
            throw new InvalidSignatureException(e);
        }
        catch (com.auth0.jwt.exceptions.TokenExpiredException e) {
            throw new TokenExpiredException(e);
        }
        catch (com.auth0.jwt.exceptions.InvalidClaimException e) {
            throw new InvalidClaimException(e);
        }
    }

    protected SingleSignOutUriBuilder singleSignOutUriBuilder() {
        return new GenericSingleSignOutBuilder(this.wellKnownConfiguration().getEndSessionEndpoint());
    }

    protected URI generateSingleSignOutUri(String callbackUrl) {
        return this.singleSignOutUriBuilder().build();
    }

    protected UserDetails getUserDetails(DecodedJWT token, String organizationId) {
        return new UserDetails(token.getSubject(), token.getClaim("email").asString(), token.getClaim("preferred_username").asString(), token.getClaim("name").asString(), this.getGroupsInOrganization(token, organizationId));
    }

    @Override
    public DecodedJWT verifyAndDecode(String token, String audience) {
        return this.verify(this.decodeJWT(token), audience);
    }

    private DecodedJWT verify(DecodedJWT token, String audience) {
        try {
            Jwk jwk = this.jwkProvider().get(token.getKeyId());
            this.verifyJwk(token, jwk);
            Algorithm algorithm = this.signatureValidationAlgorithm(jwk, token);
            JWTVerifier tokenVerifier = audience != null ? JWT.require((Algorithm)algorithm).withAudience(new String[]{audience}).build() : JWT.require((Algorithm)algorithm).build();
            return tokenVerifier.verify(token);
        }
        catch (JwkException e) {
            throw new JsonWebKeyException("JWKS error", e);
        }
    }

    private void verifyJwk(DecodedJWT token, Jwk jwk) {
        if (jwk.getUsage() != null && !jwk.getUsage().equals("sig")) {
            throw new TokenVerificationException("Token is signed with a JWK, that can not be used for signing");
        }
        if (jwk.getAlgorithm() != null && !jwk.getAlgorithm().equals(token.getAlgorithm())) {
            throw new TokenVerificationException("JWT algorithm does not match JWK algorithm");
        }
    }

    private Algorithm signatureValidationAlgorithm(Jwk jwk, DecodedJWT token) throws InvalidPublicKeyException {
        String algorithm = this.getAlgorithm(jwk, token);
        if (algorithm == null) {
            return Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)jwk.getPublicKey()), null);
        }
        switch (algorithm) {
            case "RS256": {
                return Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)jwk.getPublicKey()), null);
            }
            case "RS384": {
                return Algorithm.RSA384((RSAPublicKey)((RSAPublicKey)jwk.getPublicKey()), null);
            }
            case "RS512": {
                return Algorithm.RSA512((RSAPublicKey)((RSAPublicKey)jwk.getPublicKey()), null);
            }
            case "ES256": {
                return Algorithm.ECDSA256((ECPublicKey)((ECPublicKey)jwk.getPublicKey()), null);
            }
            case "ES384": {
                return Algorithm.ECDSA384((ECPublicKey)((ECPublicKey)jwk.getPublicKey()), null);
            }
            case "ES512": {
                return Algorithm.ECDSA512((ECPublicKey)((ECPublicKey)jwk.getPublicKey()), null);
            }
        }
        throw new TokenVerificationException(String.format("Signing algorithm '%s' is not supported", jwk.getAlgorithm()));
    }

    private String getAlgorithm(Jwk jwk, DecodedJWT token) {
        return jwk.getAlgorithm() != null ? jwk.getAlgorithm() : token.getAlgorithm();
    }

    @Override
    public List<String> getPermissions(String token) {
        return this.getPermissions(token, this.configuration.getAudience());
    }

    @Override
    public List<String> getPermissions(String token, String audience) {
        try {
            DecodedJWT jwt = this.verifyAndDecode(token, audience);
            return this.getPermissions(jwt, audience);
        }
        catch (AlgorithmMismatchException | SignatureVerificationException e) {
            throw new InvalidSignatureException(e);
        }
        catch (com.auth0.jwt.exceptions.TokenExpiredException e) {
            throw new TokenExpiredException(e);
        }
        catch (com.auth0.jwt.exceptions.InvalidClaimException e) {
            throw new InvalidClaimException(e);
        }
    }

    protected abstract List<String> getPermissions(DecodedJWT var1, String var2);

    @Override
    public List<String> getGroups(String token) {
        return this.getGroups(token, this.configuration.getAudience());
    }

    @Override
    public List<String> getGroups(String token, String audience) {
        return this.getGroupsInOrganization(token, audience, null);
    }

    @Override
    public List<String> getGroupsInOrganization(String token, String organization) {
        return this.getGroupsInOrganization(token, this.configuration.getAudience(), organization);
    }

    @Override
    public List<String> getGroupsInOrganization(String token, String audience, String organization) {
        try {
            DecodedJWT jwt = this.verifyAndDecode(token, audience);
            return this.getGroupsInOrganization(jwt, organization);
        }
        catch (AlgorithmMismatchException | SignatureVerificationException e) {
            throw new InvalidSignatureException(e);
        }
        catch (com.auth0.jwt.exceptions.TokenExpiredException e) {
            throw new TokenExpiredException(e);
        }
        catch (com.auth0.jwt.exceptions.InvalidClaimException e) {
            throw new InvalidClaimException(e);
        }
    }

    protected List<String> getGroupsInOrganization(DecodedJWT token, String organizationId) {
        if (StringUtils.isNotBlank((CharSequence)this.configuration.getBaseUrl())) {
            return this.restClient.request(new GroupRequest(UrlUtility.combinePaths(this.configuration.getBaseUrl(), GROUPS_PATH, FOR_TOKEN_PATH), token.getToken(), organizationId));
        }
        return Collections.emptyList();
    }

    protected abstract JwkProvider jwkProvider();

    protected abstract WellKnownConfiguration wellKnownConfiguration();

    protected abstract Tokens requestFreshToken(String var1);

    protected abstract boolean isRevokeAvailable();

    protected abstract boolean isSingleSignOutAvailable();
}

