/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.sdk.authorizations.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;

public class Authorization {
  private final String resourceKey;
  private final String resourceType;
  private final Set<String> permissions;

  public Authorization(
      @JsonProperty("resourceKey") final String resourceKey,
      @JsonProperty("resourceType") final String resourceType,
      @JsonProperty("permissions") final Set<String> permissions
  ) {
    this.resourceKey = resourceKey;
    this.resourceType = resourceType;
    this.permissions = permissions;
  }

  public String getResourceKey() {
    return resourceKey;
  }

  public String getResourceType() {
    return resourceType;
  }

  public Set<String> getPermissions() {
    return permissions;
  }
}
