/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.sdk.impl.rest.request;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;

public class PermissionsRequest extends Request<List<String>> {
  public PermissionsRequest(
      final String url,
      final String authentication,
      final String audience
  ) {
    super(url, new TypeReference<>() {});

    this.setAuthentication(authentication);
    this.setParams(
        Map.of("audience", audience)
    );
  }


}
