/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.sdk.impl.rest.request;

import static io.camunda.identity.sdk.impl.rest.request.Request.ContentType.JSON;
import static io.camunda.identity.sdk.impl.rest.request.Request.HttpMethod.PUT;

import com.fasterxml.jackson.core.type.TypeReference;
import io.camunda.identity.sdk.authorizations.dto.UpdateAuthorizations;

public class UpdateAuthorizationsRequest extends Request<Void> {
  public UpdateAuthorizationsRequest(
      final String path,
      final String authentication,
      final UpdateAuthorizations updateAuthorizations
  ) {
    super(path, new TypeReference<>() {});

    this.setAuthentication(authentication);
    this.setContentType(JSON);
    this.setHttpMethod(PUT);
    this.setBody(updateAuthorizations);
  }
}
