/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.sdk.tenants.dto;

import com.fasterxml.jackson.annotation.JsonProperty;

public class Tenant {
  private final String tenantId;
  private final String name;

  public Tenant(
      @JsonProperty("tenantId") final String tenantId,
      @JsonProperty("name") final String name
  ) {
    this.tenantId = tenantId;
    this.name = name;
  }

  public String getTenantId() {
    return tenantId;
  }

  public String getName() {
    return name;
  }
}
