/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.identity.autoconfigure;

import io.camunda.identity.autoconfigure.IdentityProperties;
import io.camunda.identity.sdk.Identity;
import io.camunda.identity.sdk.IdentityConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={Identity.class})
@EnableConfigurationProperties(value={IdentityProperties.class})
public class IdentityAutoConfiguration {
    private final IdentityProperties identityProperties;

    IdentityAutoConfiguration(IdentityProperties identityProperties) {
        this.identityProperties = identityProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public IdentityConfiguration identityConfiguration() {
        IdentityConfiguration.Builder builder = new IdentityConfiguration.Builder();
        builder.withType(this.identityProperties.type().name());
        if (this.identityProperties.baseUrl() != null) {
            builder.withBaseUrl(this.identityProperties.baseUrl());
        }
        if (this.identityProperties.audience() != null) {
            builder.withAudience(this.identityProperties.audience());
        }
        if (this.identityProperties.issuer() != null) {
            builder.withIssuer(this.identityProperties.issuer());
        }
        if (this.identityProperties.issuerBackendUrl() != null) {
            builder.withIssuerBackendUrl(this.identityProperties.issuerBackendUrl());
        }
        if (this.identityProperties.clientId() != null) {
            builder.withClientId(this.identityProperties.clientId());
        }
        if (this.identityProperties.clientSecret() != null) {
            builder.withClientSecret(this.identityProperties.clientSecret());
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public Identity identity(IdentityConfiguration identityConfiguration) {
        return new Identity(identityConfiguration);
    }
}

