/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.starter;

import static org.springframework.http.HttpStatus.NO_CONTENT;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@ConditionalOnBean(LogoutListener.class)
@RestController
@RequestMapping("/identity-auth")
public class IdentityCallbackController {
  private final LogoutListener logoutListener;

  public IdentityCallbackController(final LogoutListener logoutListener) {
    this.logoutListener = logoutListener;
  }

  @GetMapping("/logout-callback")
  @ResponseStatus(NO_CONTENT)
  public void logoutCallback(@RequestParam(value = "sid", required = false) final String sid,
                             @RequestParam(value = "iss", required = false) final String iss,
                             final HttpServletRequest request,
                             final HttpServletResponse response) {
    logoutListener.onLogout(sid, iss, request, response);
  }
}
