/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.common.auth;

import io.camunda.common.auth.JwtAuthentication;
import io.camunda.common.auth.JwtConfig;
import io.camunda.common.auth.JwtCredential;
import io.camunda.common.auth.Product;
import io.camunda.common.auth.SaaSAuthenticationBuilder;
import io.camunda.common.auth.TokenRequest;
import io.camunda.common.auth.TokenResponse;
import io.camunda.common.json.JsonMapper;
import java.time.LocalDateTime;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaaSAuthentication
extends JwtAuthentication {
    private static final Logger LOG = LoggerFactory.getLogger(SaaSAuthentication.class);
    private final JsonMapper jsonMapper;

    public SaaSAuthentication(JwtConfig jwtConfig, JsonMapper jsonMapper) {
        super(jwtConfig);
        this.jsonMapper = jsonMapper;
    }

    public static SaaSAuthenticationBuilder builder() {
        return new SaaSAuthenticationBuilder();
    }

    private TokenResponse retrieveToken(Product product, JwtCredential jwtCredential) {
        TokenResponse tokenResponse;
        block8: {
            CloseableHttpClient client = HttpClients.createDefault();
            try {
                HttpPost request = this.buildRequest(jwtCredential);
                tokenResponse = (TokenResponse)client.execute((ClassicHttpRequest)request, response -> {
                    try {
                        return this.jsonMapper.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), TokenResponse.class);
                    }
                    catch (Exception e) {
                        String errorMessage = "Token retrieval failed from: {}\nResponse code: {}\nAudience: {}\n";
                        LOG.error("Token retrieval failed from: {}\nResponse code: {}\nAudience: {}\n", new Object[]{jwtCredential.getAuthUrl(), response.getCode(), jwtCredential.getAudience()});
                        throw e;
                    }
                });
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.error("Authenticating for " + String.valueOf((Object)product) + " failed due to " + String.valueOf(e));
                    throw new RuntimeException("Unable to authenticate", e);
                }
            }
            client.close();
        }
        return tokenResponse;
    }

    private HttpPost buildRequest(JwtCredential jwtCredential) {
        HttpPost httpPost = new HttpPost(jwtCredential.getAuthUrl());
        httpPost.addHeader("Content-Type", (Object)"application/json");
        TokenRequest tokenRequest = new TokenRequest(jwtCredential.getAudience(), jwtCredential.getClientId(), jwtCredential.getClientSecret());
        httpPost.setEntity((HttpEntity)new StringEntity(this.jsonMapper.toJson(tokenRequest)));
        return httpPost;
    }

    @Override
    protected JwtAuthentication.JwtToken generateToken(Product product, JwtCredential credential) {
        TokenResponse tokenResponse = this.retrieveToken(product, credential);
        return new JwtAuthentication.JwtToken(tokenResponse.getAccessToken(), LocalDateTime.now().plusSeconds(tokenResponse.getExpiresIn().intValue()));
    }
}

