/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.configuration;

import io.camunda.common.auth.Authentication;
import io.camunda.common.auth.DefaultNoopAuthentication;
import io.camunda.common.auth.JwtConfig;
import io.camunda.common.auth.JwtCredential;
import io.camunda.common.auth.Product;
import io.camunda.common.auth.SaaSAuthentication;
import io.camunda.common.auth.SaaSAuthenticationBuilder;
import io.camunda.common.auth.SelfManagedAuthentication;
import io.camunda.common.auth.SelfManagedAuthenticationBuilder;
import io.camunda.common.auth.SimpleAuthentication;
import io.camunda.common.auth.SimpleConfig;
import io.camunda.common.auth.identity.IdentityConfig;
import io.camunda.common.json.JsonMapper;
import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.zeebe.spring.client.properties.CommonConfigurationProperties;
import io.camunda.zeebe.spring.client.properties.ZeebeClientConfigurationProperties;
import io.camunda.zeebe.spring.client.properties.ZeebeSelfManagedProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;

@EnableConfigurationProperties(value={CommonConfigurationProperties.class, ZeebeSelfManagedProperties.class})
public class CommonClientConfiguration {
    @Autowired(required=false)
    CommonConfigurationProperties commonConfigurationProperties;
    @Autowired(required=false)
    ZeebeClientConfigurationProperties zeebeClientConfigurationProperties;
    @Autowired(required=false)
    ZeebeSelfManagedProperties zeebeSelfManagedProperties;
    @Autowired(required=false)
    private IdentityConfiguration identityConfigurationFromProperties;

    @Bean
    public Authentication authentication(JsonMapper jsonMapper) {
        if (this.zeebeClientConfigurationProperties != null) {
            if (this.zeebeClientConfigurationProperties.getCloud().getClusterId() != null) {
                return ((SaaSAuthenticationBuilder)SaaSAuthentication.builder().withJwtConfig(this.configureJwtConfig())).withJsonMapper(jsonMapper).build();
            }
            if (this.zeebeClientConfigurationProperties.getBroker().getGatewayAddress() != null || this.zeebeSelfManagedProperties.getGatewayAddress() != null) {
                if (this.identityConfigurationFromProperties != null && StringUtils.hasText((String)this.identityConfigurationFromProperties.getClientId())) {
                    JwtConfig jwtConfig = this.configureJwtConfig();
                    IdentityConfig identityConfig = this.configureIdentities();
                    return ((SelfManagedAuthenticationBuilder)SelfManagedAuthentication.builder().withJwtConfig(jwtConfig)).withIdentityConfig(identityConfig).build();
                }
                if (this.commonConfigurationProperties != null && this.commonConfigurationProperties.getKeycloak().getUrl() != null) {
                    JwtConfig jwtConfig = this.configureJwtConfig();
                    IdentityConfig identityConfig = this.configureIdentities();
                    return ((SelfManagedAuthenticationBuilder)SelfManagedAuthentication.builder().withJwtConfig(jwtConfig)).withIdentityConfig(identityConfig).build();
                }
                if (this.commonConfigurationProperties != null && this.commonConfigurationProperties.getKeycloak().getTokenUrl() != null) {
                    JwtConfig jwtConfig = this.configureJwtConfig();
                    IdentityConfig identityConfig = this.configureIdentities();
                    return ((SelfManagedAuthenticationBuilder)SelfManagedAuthentication.builder().withJwtConfig(jwtConfig)).withIdentityConfig(identityConfig).build();
                }
                if (this.commonConfigurationProperties != null && this.commonConfigurationProperties.getUsername() != null && this.commonConfigurationProperties.getPassword() != null) {
                    SimpleConfig simpleConfig = new SimpleConfig();
                    return SimpleAuthentication.builder().withSimpleConfig(simpleConfig).withSimpleUrl(this.commonConfigurationProperties.getUrl()).build();
                }
            }
        }
        return new DefaultNoopAuthentication();
    }

    private JwtConfig configureJwtConfig() {
        JwtConfig jwtConfig = new JwtConfig();
        if (this.zeebeClientConfigurationProperties.getCloud().getClientId() != null && this.zeebeClientConfigurationProperties.getCloud().getClientSecret() != null) {
            jwtConfig.addProduct(Product.ZEEBE, new JwtCredential(this.zeebeClientConfigurationProperties.getCloud().getClientId(), this.zeebeClientConfigurationProperties.getCloud().getClientSecret(), this.zeebeClientConfigurationProperties.getCloud().getAudience(), this.zeebeClientConfigurationProperties.getCloud().getAuthUrl()));
        } else if (this.zeebeSelfManagedProperties.getClientId() != null && this.zeebeSelfManagedProperties.getClientSecret() != null) {
            jwtConfig.addProduct(Product.ZEEBE, new JwtCredential(this.zeebeSelfManagedProperties.getClientId(), this.zeebeSelfManagedProperties.getClientSecret(), this.zeebeSelfManagedProperties.getAudience(), this.zeebeSelfManagedProperties.getAuthServer()));
        } else if (this.commonConfigurationProperties.getClientId() != null && this.commonConfigurationProperties.getClientSecret() != null) {
            jwtConfig.addProduct(Product.ZEEBE, new JwtCredential(this.commonConfigurationProperties.getClientId(), this.commonConfigurationProperties.getClientSecret(), this.zeebeClientConfigurationProperties.getCloud().getAudience(), this.zeebeClientConfigurationProperties.getCloud().getAuthUrl()));
        }
        return jwtConfig;
    }

    private IdentityConfig configureIdentities() {
        IdentityConfig identityConfig = new IdentityConfig();
        return identityConfig;
    }
}

