/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.jobhandling;

import io.camunda.zeebe.client.api.worker.BackoffSupplier;
import io.camunda.zeebe.spring.client.jobhandling.CommandExceptionHandlingStrategy;
import io.camunda.zeebe.spring.client.jobhandling.CommandWrapper;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.lang.invoke.MethodHandles;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCommandExceptionHandlingStrategy
implements CommandExceptionHandlingStrategy {
    public static final Set<Status.Code> RETRIABLE_CODES = EnumSet.of(Status.Code.CANCELLED, new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.RESOURCE_EXHAUSTED, Status.Code.ABORTED, Status.Code.UNAVAILABLE, Status.Code.DATA_LOSS});
    public static final Set<Status.Code> IGNORABLE_FAILURE_CODES = EnumSet.of(Status.Code.NOT_FOUND);
    public static final Set<Status.Code> FAILURE_CODES = EnumSet.of(Status.Code.INVALID_ARGUMENT, new Status.Code[]{Status.Code.PERMISSION_DENIED, Status.Code.FAILED_PRECONDITION, Status.Code.OUT_OF_RANGE, Status.Code.UNIMPLEMENTED, Status.Code.INTERNAL, Status.Code.UNAUTHENTICATED});
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final BackoffSupplier backoffSupplier;
    private final ScheduledExecutorService scheduledExecutorService;

    public DefaultCommandExceptionHandlingStrategy(BackoffSupplier backoffSupplier, ScheduledExecutorService scheduledExecutorService) {
        this.backoffSupplier = backoffSupplier;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Override
    public void handleCommandError(CommandWrapper command, Throwable throwable) {
        if (StatusRuntimeException.class.isAssignableFrom(throwable.getClass())) {
            StatusRuntimeException exception = (StatusRuntimeException)throwable;
            Status.Code code = exception.getStatus().getCode();
            if (!RETRIABLE_CODES.contains(code) || !IGNORABLE_FAILURE_CODES.contains(code) || FAILURE_CODES.contains(code)) {
                throw new RuntimeException("Could not execute " + String.valueOf(command) + " due to exception: " + throwable.getMessage(), throwable);
            }
            if (RETRIABLE_CODES.contains(code)) {
                if (!command.hasMoreRetries()) {
                    throw new RuntimeException("Could not execute " + String.valueOf(command) + " due to error of type '" + String.valueOf(code) + "' and no retries are left", throwable);
                }
                command.increaseBackoffUsing(this.backoffSupplier);
                LOG.warn("Retrying {} after error of type '{}' with backoff", (Object)command, (Object)code);
                command.scheduleExecutionUsing(this.scheduledExecutorService);
                return;
            }
            throw new RuntimeException("Could not execute " + String.valueOf(command) + " due to error of type '" + String.valueOf(code) + "'", throwable);
        }
    }
}

