/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.configuration;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyUtil.class);

    public static <T> T getOrLegacyOrDefault(String propertyName, Supplier<T> propertySupplier, Supplier<T> legacyPropertySupplier, T defaultProperty, Map<String, Object> configCache) {
        if (configCache != null && configCache.containsKey(propertyName)) {
            Object propertyValue = configCache.get(propertyName);
            LOG.debug("Property {} loading from cache. Property is set to {}", (Object)propertyName, propertyValue);
            return (T)propertyValue;
        }
        T property = PropertyUtil.getPropertyFromSupplier(legacyPropertySupplier, propertyName, "legacy");
        if (property == null || property.equals(defaultProperty)) {
            property = PropertyUtil.getPropertyFromSupplier(propertySupplier, propertyName, "property");
        }
        if (property == null || property.equals(defaultProperty)) {
            LOG.debug("Property {}: not set or default, using default", (Object)propertyName);
            property = defaultProperty;
        }
        if (configCache != null) {
            configCache.put(propertyName, property);
        }
        LOG.debug("Property {} set to {}", (Object)propertyName, property);
        return property;
    }

    public static <T> T getOrDefault(String propertyName, Supplier<T> propertySupplier, T defaultProperty, Map<String, Object> configCache) {
        return PropertyUtil.getOrLegacyOrDefault(propertyName, propertySupplier, PropertyUtil.noPropertySupplier(), defaultProperty, configCache);
    }

    private static <T> Supplier<T> noPropertySupplier() {
        return () -> null;
    }

    private static <T> T getPropertyFromSupplier(Supplier<T> supplier, String propertyName, String propertyType) {
        T property = null;
        try {
            LOG.debug("Property {}: not set or default, applying {} property", (Object)propertyName, (Object)propertyType);
            property = supplier.get();
        }
        catch (Exception e) {
            LOG.debug("Error while loading {} property {}", new Object[]{propertyType, propertyName, e});
        }
        return property;
    }

    public static <T> Supplier<T> prioritized(T defaultProperty, List<Supplier<T>> suppliers) {
        for (Supplier<T> supplier : suppliers) {
            try {
                T property = supplier.get();
                if (property == null || property.equals(defaultProperty)) continue;
                return supplier;
            }
            catch (Exception exception) {
            }
        }
        return () -> defaultProperty;
    }
}

