/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.common.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.camunda.zeebe.spring.common.exception.SdkException;
import io.camunda.zeebe.spring.common.json.JsonMapper;
import java.io.IOException;

public class SdkObjectMapper
implements JsonMapper {
    private final ObjectMapper objectMapper;

    public SdkObjectMapper() {
        this(new ObjectMapper());
    }

    public SdkObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    public <T> T fromJson(String json, Class<T> typeClass) {
        try {
            return (T)this.objectMapper.readValue(json, typeClass);
        }
        catch (IOException e) {
            throw new SdkException(String.format("Failed to deserialize json '%s' to class '%s'", json, typeClass), e);
        }
    }

    @Override
    public String toJson(Object value) {
        try {
            return this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new SdkException(String.format("Failed to serialize object '%s' to json", value), e);
        }
    }
}

