/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.properties;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.spring.client.annotation.Variable;
import io.camunda.zeebe.spring.client.annotation.VariablesAsType;
import io.camunda.zeebe.spring.client.annotation.customizer.ZeebeWorkerValueCustomizer;
import io.camunda.zeebe.spring.client.annotation.value.ZeebeWorkerValue;
import io.camunda.zeebe.spring.client.bean.CopyNotNullBeanUtilsBean;
import io.camunda.zeebe.spring.client.bean.CopyWithProtectionBeanUtilsBean;
import io.camunda.zeebe.spring.client.bean.MethodInfo;
import io.camunda.zeebe.spring.client.bean.ParameterInfo;
import io.camunda.zeebe.spring.client.configuration.PropertyUtil;
import io.camunda.zeebe.spring.client.properties.CamundaClientProperties;
import io.camunda.zeebe.spring.client.properties.ZeebeClientConfigurationProperties;
import io.camunda.zeebe.spring.client.properties.common.ZeebeClientProperties;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class PropertyBasedZeebeWorkerValueCustomizer
implements ZeebeWorkerValueCustomizer {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyBasedZeebeWorkerValueCustomizer.class);
    private static final CopyNotNullBeanUtilsBean COPY_NOT_NULL_BEAN_UTILS_BEAN = new CopyNotNullBeanUtilsBean();
    private static final CopyWithProtectionBeanUtilsBean COPY_WITH_PROTECTION_BEAN_UTILS_BEAN = new CopyWithProtectionBeanUtilsBean(Set.of("name", "type", "fetchVariables", "tenantIds"));
    private final ZeebeClientConfigurationProperties zeebeClientConfigurationProperties;
    private final CamundaClientProperties camundaClientProperties;

    public PropertyBasedZeebeWorkerValueCustomizer(ZeebeClientConfigurationProperties zeebeClientConfigurationProperties, CamundaClientProperties camundaClientProperties) {
        this.zeebeClientConfigurationProperties = zeebeClientConfigurationProperties;
        this.camundaClientProperties = camundaClientProperties;
    }

    @Override
    public void customize(ZeebeWorkerValue zeebeWorker) {
        this.applyDefaultWorkerName(zeebeWorker);
        this.applyDefaultJobWorkerType(zeebeWorker);
        this.applyDefaultJobWorkerTenantIds(zeebeWorker);
        this.applyFetchVariables(zeebeWorker);
        this.applyOverrides(zeebeWorker);
    }

    private void applyFetchVariables(ZeebeWorkerValue zeebeWorkerValue) {
        if (this.hasActivatedJobInjected(zeebeWorkerValue)) {
            LOG.debug("Worker '{}': ActivatedJob is injected, no variable filtering possible", (Object)zeebeWorkerValue.getName());
        } else if (zeebeWorkerValue.getForceFetchAllVariables() != null && zeebeWorkerValue.getForceFetchAllVariables().booleanValue()) {
            LOG.debug("Worker '{}': Force fetch all variables is enabled", (Object)zeebeWorkerValue.getName());
            zeebeWorkerValue.setFetchVariables(List.of());
        } else {
            HashSet<String> variables = new HashSet<String>();
            if (zeebeWorkerValue.getFetchVariables() != null) {
                variables.addAll(zeebeWorkerValue.getFetchVariables());
            }
            variables.addAll(this.readZeebeVariableParameters(zeebeWorkerValue.getMethodInfo()).stream().map(this::extractVariableName).toList());
            variables.addAll(this.readVariablesAsTypeParameters(zeebeWorkerValue.getMethodInfo()));
            zeebeWorkerValue.setFetchVariables(variables.stream().toList());
            LOG.debug("Worker '{}': Fetching only required variables {}", (Object)zeebeWorkerValue.getName(), variables);
        }
    }

    private boolean hasActivatedJobInjected(ZeebeWorkerValue zeebeWorkerValue) {
        return zeebeWorkerValue.getMethodInfo().getParameters().stream().anyMatch(p -> p.getParameterInfo().getType().isAssignableFrom(ActivatedJob.class));
    }

    private List<ParameterInfo> readZeebeVariableParameters(MethodInfo methodInfo) {
        return methodInfo.getParametersFilteredByAnnotation(Variable.class);
    }

    private String extractVariableName(ParameterInfo parameterInfo) {
        Variable variableAnnotation = parameterInfo.getParameterInfo().getAnnotation(Variable.class);
        if (variableAnnotation != null && !"$NULL$".equals(variableAnnotation.name())) {
            return variableAnnotation.name();
        }
        return parameterInfo.getParameterName();
    }

    private List<String> readVariablesAsTypeParameters(MethodInfo methodInfo) {
        ArrayList<String> result = new ArrayList<String>();
        List<ParameterInfo> parameters = methodInfo.getParametersFilteredByAnnotation(VariablesAsType.class);
        parameters.forEach(pi -> ReflectionUtils.doWithFields(pi.getParameterInfo().getType(), f -> result.add(this.extractFieldName(f))));
        return result;
    }

    private String extractFieldName(Field field) {
        String value;
        if (field.isAnnotationPresent(JsonProperty.class) && StringUtils.isNotBlank((CharSequence)(value = field.getAnnotation(JsonProperty.class).value()))) {
            return value;
        }
        return field.getName();
    }

    private void applyOverrides(ZeebeWorkerValue zeebeWorker) {
        Map workerConfigurationMap = PropertyUtil.getLegacyOrPropertyOrDefault("Override", () -> this.camundaClientProperties.getZeebe().getOverride(), () -> this.zeebeClientConfigurationProperties.getWorker().getOverride(), new HashMap(), null);
        try {
            if (Optional.ofNullable(this.camundaClientProperties.getZeebe()).map(ZeebeClientProperties::getDefaults).isPresent()) {
                COPY_WITH_PROTECTION_BEAN_UTILS_BEAN.copyProperties(zeebeWorker, this.camundaClientProperties.getZeebe().getDefaults());
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Error while copying properties from " + String.valueOf(this.camundaClientProperties.getZeebe().getDefaults()) + " to " + String.valueOf(zeebeWorker), e);
        }
        String workerType = zeebeWorker.getType();
        if (workerConfigurationMap.containsKey(workerType)) {
            ZeebeWorkerValue zeebeWorkerValue = (ZeebeWorkerValue)workerConfigurationMap.get(workerType);
            LOG.debug("Worker '{}': Applying overrides {}", (Object)workerType, (Object)zeebeWorkerValue);
            try {
                COPY_NOT_NULL_BEAN_UTILS_BEAN.copyProperties(zeebeWorker, zeebeWorkerValue);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Error while copying properties from " + String.valueOf(zeebeWorkerValue) + " to " + String.valueOf(zeebeWorker), e);
            }
        }
    }

    private void applyDefaultWorkerName(ZeebeWorkerValue zeebeWorker) {
        String defaultJobWorkerName = PropertyUtil.getLegacyOrPropertyOrDefault("DefaultJobWorkerName", () -> this.camundaClientProperties.getZeebe().getDefaults().getName(), this.zeebeClientConfigurationProperties::getDefaultJobWorkerName, null, null);
        if (StringUtils.isBlank((CharSequence)zeebeWorker.getName())) {
            if (StringUtils.isNotBlank((CharSequence)defaultJobWorkerName)) {
                LOG.debug("Worker '{}': Setting name to default {}", (Object)zeebeWorker.getName(), (Object)defaultJobWorkerName);
                zeebeWorker.setName(defaultJobWorkerName);
            } else {
                String generatedJobWorkerName = zeebeWorker.getMethodInfo().getBeanName() + "#" + zeebeWorker.getMethodInfo().getMethodName();
                LOG.debug("Worker '{}': Setting name to generated {}", (Object)zeebeWorker.getName(), (Object)generatedJobWorkerName);
                zeebeWorker.setName(generatedJobWorkerName);
            }
        }
    }

    private void applyDefaultJobWorkerType(ZeebeWorkerValue zeebeWorker) {
        String defaultJobWorkerType = PropertyUtil.getLegacyOrPropertyOrDefault("DefaultJobWorkerType", () -> this.camundaClientProperties.getZeebe().getDefaults().getType(), this.zeebeClientConfigurationProperties::getDefaultJobWorkerType, null, null);
        if (StringUtils.isBlank((CharSequence)zeebeWorker.getType())) {
            if (StringUtils.isNotBlank((CharSequence)defaultJobWorkerType)) {
                LOG.debug("Worker '{}': Setting type to default {}", (Object)zeebeWorker.getName(), (Object)defaultJobWorkerType);
                zeebeWorker.setType(defaultJobWorkerType);
            } else {
                String generatedJobWorkerType = zeebeWorker.getMethodInfo().getMethodName();
                LOG.debug("Worker '{}': Setting type to generated {}", (Object)zeebeWorker.getName(), (Object)generatedJobWorkerType);
                zeebeWorker.setType(generatedJobWorkerType);
            }
        }
    }

    private void applyDefaultJobWorkerTenantIds(ZeebeWorkerValue zeebeWorker) {
        HashSet<String> tenantIds = new HashSet<String>();
        tenantIds.addAll(PropertyUtil.getLegacyOrPropertyOrDefault("DefaultJobWorkerTenantIds", PropertyUtil.prioritized(ZeebeClientConfigurationProperties.DEFAULT.getDefaultJobWorkerTenantIds(), List.of(this.camundaClientProperties.getZeebe().getDefaults()::getTenantIds, this.camundaClientProperties::getTenantIds)), this.zeebeClientConfigurationProperties::getDefaultJobWorkerTenantIds, ZeebeClientConfigurationProperties.DEFAULT.getDefaultJobWorkerTenantIds(), null));
        if (zeebeWorker.getTenantIds() != null) {
            tenantIds.addAll(zeebeWorker.getTenantIds());
        }
        if (!tenantIds.isEmpty()) {
            LOG.debug("Worker '{}': Setting tenantIds to {}", (Object)zeebeWorker.getName(), tenantIds);
            zeebeWorker.setTenantIds(new ArrayList<String>(tenantIds));
        }
    }
}

