/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.configuration;

import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.impl.NoopCredentialsProvider;
import io.camunda.zeebe.client.impl.oauth.OAuthCredentialsProviderBuilder;
import io.camunda.zeebe.client.impl.util.Environment;
import io.camunda.zeebe.spring.client.configuration.PropertyUtil;
import io.camunda.zeebe.spring.client.jobhandling.ZeebeClientExecutorService;
import io.camunda.zeebe.spring.client.properties.CamundaClientProperties;
import io.camunda.zeebe.spring.client.properties.PropertiesUtil;
import io.camunda.zeebe.spring.client.properties.ZeebeClientConfigurationProperties;
import io.grpc.ClientInterceptor;
import jakarta.annotation.PostConstruct;
import java.net.MalformedURLException;
import java.net.URI;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class ZeebeClientConfigurationImpl
implements ZeebeClientConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(ZeebeClientConfigurationImpl.class);
    private final Map<String, Object> configCache = new HashMap<String, Object>();
    private final ZeebeClientConfigurationProperties properties;
    private final CamundaClientProperties camundaClientProperties;
    private final JsonMapper jsonMapper;
    private final List<ClientInterceptor> interceptors;
    private final List<AsyncExecChainHandler> chainHandlers;
    private final ZeebeClientExecutorService zeebeClientExecutorService;

    @Autowired
    public ZeebeClientConfigurationImpl(ZeebeClientConfigurationProperties properties, CamundaClientProperties camundaClientProperties, JsonMapper jsonMapper, List<ClientInterceptor> interceptors, List<AsyncExecChainHandler> chainHandlers, ZeebeClientExecutorService zeebeClientExecutorService) {
        this.properties = properties;
        this.camundaClientProperties = camundaClientProperties;
        this.jsonMapper = jsonMapper;
        this.interceptors = interceptors;
        this.chainHandlers = chainHandlers;
        this.zeebeClientExecutorService = zeebeClientExecutorService;
    }

    @PostConstruct
    public void applyLegacy() {
        this.properties.applyOverrides();
    }

    public String getGatewayAddress() {
        return PropertyUtil.getOrLegacyOrDefault("GatewayAddress", this::composeGatewayAddress, () -> PropertiesUtil.getZeebeGatewayAddress(this.properties), ZeebeClientConfigurationProperties.DEFAULT.getGatewayAddress(), this.configCache);
    }

    public URI getRestAddress() {
        return PropertyUtil.getOrLegacyOrDefault("RestAddress", () -> this.camundaClientProperties.getZeebe().getRestAddress(), () -> this.properties.getBroker().getRestAddress(), ZeebeClientConfigurationProperties.DEFAULT.getRestAddress(), this.configCache);
    }

    public URI getGrpcAddress() {
        return PropertyUtil.getOrLegacyOrDefault("GrpcAddress", () -> this.camundaClientProperties.getZeebe().getGrpcAddress(), this.properties::getGrpcAddress, ZeebeClientConfigurationProperties.DEFAULT.getGrpcAddress(), this.configCache);
    }

    public String getDefaultTenantId() {
        return PropertyUtil.getOrLegacyOrDefault("DefaultTenantId", PropertyUtil.prioritized(ZeebeClientConfigurationProperties.DEFAULT.getDefaultTenantId(), List.of(() -> this.camundaClientProperties.getTenantIds().get(0), () -> this.camundaClientProperties.getZeebe().getDefaults().getTenantIds().get(0))), this.properties::getDefaultTenantId, ZeebeClientConfigurationProperties.DEFAULT.getDefaultTenantId(), this.configCache);
    }

    public List<String> getDefaultJobWorkerTenantIds() {
        return PropertyUtil.getOrLegacyOrDefault("DefaultJobWorkerTenantIds", PropertyUtil.prioritized(ZeebeClientConfigurationProperties.DEFAULT.getDefaultJobWorkerTenantIds(), List.of(this.camundaClientProperties::getTenantIds, () -> this.camundaClientProperties.getZeebe().getDefaults().getTenantIds())), this.properties::getDefaultJobWorkerTenantIds, ZeebeClientConfigurationProperties.DEFAULT.getDefaultJobWorkerTenantIds(), this.configCache);
    }

    public int getNumJobWorkerExecutionThreads() {
        return PropertyUtil.getOrLegacyOrDefault("NumJobWorkerExecutionThreads", () -> this.camundaClientProperties.getZeebe().getExecutionThreads(), () -> this.properties.getWorker().getThreads(), ZeebeClientConfigurationProperties.DEFAULT.getNumJobWorkerExecutionThreads(), this.configCache);
    }

    public int getDefaultJobWorkerMaxJobsActive() {
        return PropertyUtil.getOrLegacyOrDefault("DefaultJobWorkerMaxJobsActive", () -> this.camundaClientProperties.getZeebe().getDefaults().getMaxJobsActive(), () -> this.properties.getWorker().getMaxJobsActive(), ZeebeClientConfigurationProperties.DEFAULT.getDefaultJobWorkerMaxJobsActive(), this.configCache);
    }

    public String getDefaultJobWorkerName() {
        return PropertyUtil.getOrLegacyOrDefault("DefaultJobWorkerName", () -> this.camundaClientProperties.getZeebe().getDefaults().getName(), () -> this.properties.getWorker().getDefaultName(), ZeebeClientConfigurationProperties.DEFAULT.getDefaultJobWorkerName(), this.configCache);
    }

    public Duration getDefaultJobTimeout() {
        return PropertyUtil.getOrLegacyOrDefault("DefaultJobTimeout", () -> this.camundaClientProperties.getZeebe().getDefaults().getTimeout(), () -> this.properties.getJob().getTimeout(), ZeebeClientConfigurationProperties.DEFAULT.getDefaultJobTimeout(), this.configCache);
    }

    public Duration getDefaultJobPollInterval() {
        return PropertyUtil.getOrLegacyOrDefault("DefaultJobPollInterval", () -> this.camundaClientProperties.getZeebe().getDefaults().getPollInterval(), () -> this.properties.getJob().getPollInterval(), ZeebeClientConfigurationProperties.DEFAULT.getDefaultJobPollInterval(), this.configCache);
    }

    public Duration getDefaultMessageTimeToLive() {
        return PropertyUtil.getOrLegacyOrDefault("DefaultMessageTimeToLive", () -> this.camundaClientProperties.getZeebe().getMessageTimeToLive(), () -> this.properties.getMessage().getTimeToLive(), ZeebeClientConfigurationProperties.DEFAULT.getDefaultMessageTimeToLive(), this.configCache);
    }

    public Duration getDefaultRequestTimeout() {
        return PropertyUtil.getOrLegacyOrDefault("DefaultRequestTimeout", PropertyUtil.prioritized(ZeebeClientConfigurationProperties.DEFAULT.getDefaultRequestTimeout(), List.of(() -> this.camundaClientProperties.getZeebe().getRequestTimeout(), () -> this.camundaClientProperties.getZeebe().getDefaults().getRequestTimeout())), this.properties::getRequestTimeout, ZeebeClientConfigurationProperties.DEFAULT.getDefaultRequestTimeout(), this.configCache);
    }

    public boolean isPlaintextConnectionEnabled() {
        return PropertyUtil.getOrLegacyOrDefault("PlaintextConnectionEnabled", this::composePlaintext, () -> this.properties.getSecurity().isPlaintext(), ZeebeClientConfigurationProperties.DEFAULT.isPlaintextConnectionEnabled(), this.configCache);
    }

    public String getCaCertificatePath() {
        return PropertyUtil.getOrLegacyOrDefault("CaCertificatePath", () -> this.camundaClientProperties.getZeebe().getCaCertificatePath(), () -> this.properties.getSecurity().getCertPath(), ZeebeClientConfigurationProperties.DEFAULT.getCaCertificatePath(), this.configCache);
    }

    public CredentialsProvider getCredentialsProvider() {
        return PropertyUtil.getOrLegacyOrDefault("CredentialsProvider", this::credentialsProvider, this::legacyCredentialsProvider, null, this.configCache);
    }

    public Duration getKeepAlive() {
        return PropertyUtil.getOrLegacyOrDefault("KeepAlive", () -> this.camundaClientProperties.getZeebe().getKeepAlive(), () -> this.properties.getBroker().getKeepAlive(), ZeebeClientConfigurationProperties.DEFAULT.getKeepAlive(), this.configCache);
    }

    public List<ClientInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public List<AsyncExecChainHandler> getChainHandlers() {
        return this.chainHandlers;
    }

    public JsonMapper getJsonMapper() {
        return this.jsonMapper;
    }

    public String getOverrideAuthority() {
        return PropertyUtil.getOrLegacyOrDefault("OverrideAuthority", () -> this.camundaClientProperties.getZeebe().getOverrideAuthority(), () -> this.properties.getSecurity().getOverrideAuthority(), ZeebeClientConfigurationProperties.DEFAULT.getOverrideAuthority(), this.configCache);
    }

    public int getMaxMessageSize() {
        return PropertyUtil.getOrLegacyOrDefault("MaxMessageSize", () -> this.camundaClientProperties.getZeebe().getMaxMessageSize(), () -> this.properties.getMessage().getMaxMessageSize(), ZeebeClientConfigurationProperties.DEFAULT.getMaxMessageSize(), this.configCache);
    }

    public int getMaxMetadataSize() {
        return PropertyUtil.getOrDefault("MaxMetadataSize", () -> this.camundaClientProperties.getZeebe().getMaxMessageSize(), ZeebeClientConfigurationProperties.DEFAULT.getMaxMetadataSize(), this.configCache);
    }

    public ScheduledExecutorService jobWorkerExecutor() {
        return this.zeebeClientExecutorService.get();
    }

    public boolean ownsJobWorkerExecutor() {
        return PropertyUtil.getOrLegacyOrDefault("ownsJobWorkerExecutor", this.zeebeClientExecutorService::isOwnedByZeebeClient, this.properties::ownsJobWorkerExecutor, ZeebeClientConfigurationProperties.DEFAULT.ownsJobWorkerExecutor(), this.configCache);
    }

    public boolean getDefaultJobWorkerStreamEnabled() {
        return PropertyUtil.getOrLegacyOrDefault("DefaultJobWorkerStreamEnabled", () -> this.camundaClientProperties.getZeebe().getDefaults().getStreamEnabled(), this.properties::getDefaultJobWorkerStreamEnabled, ZeebeClientConfigurationProperties.DEFAULT.getDefaultJobWorkerStreamEnabled(), this.configCache);
    }

    public boolean useDefaultRetryPolicy() {
        return false;
    }

    public boolean preferRestOverGrpc() {
        return this.camundaClientProperties.getZeebe().isPreferRestOverGrpc();
    }

    private CredentialsProvider credentialsProvider() {
        CamundaClientProperties.ClientMode clientMode = this.camundaClientProperties.getMode();
        if (CamundaClientProperties.ClientMode.selfManaged.equals((Object)clientMode) || CamundaClientProperties.ClientMode.saas.equals((Object)clientMode)) {
            return CredentialsProvider.newCredentialsProviderBuilder().clientId(this.camundaClientProperties.getAuth().getClientId()).clientSecret(this.camundaClientProperties.getAuth().getClientSecret()).audience(this.camundaClientProperties.getZeebe().getAudience()).authorizationServerUrl(this.camundaClientProperties.getAuth().getIssuer()).scope(this.camundaClientProperties.getZeebe().getScope()).build();
        }
        return new NoopCredentialsProvider();
    }

    private String composeGatewayAddress() {
        int defaultPort;
        URI gatewayUrl = this.camundaClientProperties.getZeebe().getGrpcAddress();
        int port = gatewayUrl.getPort();
        String host = gatewayUrl.getHost();
        if (port != -1) {
            return this.composeAddressWithPort(host, port, "Gateway port is set");
        }
        try {
            defaultPort = gatewayUrl.toURL().getDefaultPort();
        }
        catch (MalformedURLException e) {
            LOG.warn("Invalid gateway url: {}", (Object)gatewayUrl);
            defaultPort = -1;
        }
        if (defaultPort != -1) {
            return this.composeAddressWithPort(host, defaultPort, "Gateway port has default");
        }
        LOG.debug("Gateway cannot be determined, address will be '{}'", (Object)host);
        return host;
    }

    private String composeAddressWithPort(String host, int port, String debugMessage) {
        String gatewayAddress = host + ":" + port;
        LOG.debug(debugMessage + ", address will be '{}'", (Object)gatewayAddress);
        return gatewayAddress;
    }

    private boolean composePlaintext() {
        String protocol;
        return switch (protocol = this.camundaClientProperties.getZeebe().getGrpcAddress().getScheme()) {
            case "http" -> true;
            case "https" -> false;
            default -> throw new IllegalStateException(String.format("Unrecognized zeebe protocol '%s'", protocol));
        };
    }

    private CredentialsProvider legacyCredentialsProvider() {
        if (StringUtils.hasText((String)this.properties.getCloud().getClientId()) && StringUtils.hasText((String)this.properties.getCloud().getClientSecret())) {
            return CredentialsProvider.newCredentialsProviderBuilder().clientId(this.properties.getCloud().getClientId()).clientSecret(this.properties.getCloud().getClientSecret()).audience(this.properties.getCloud().getAudience()).scope(this.properties.getCloud().getScope()).authorizationServerUrl(this.properties.getCloud().getAuthUrl()).credentialsCachePath(this.properties.getCloud().getCredentialsCachePath()).build();
        }
        if (Environment.system().get("ZEEBE_CLIENT_ID") != null && Environment.system().get("ZEEBE_CLIENT_SECRET") != null) {
            OAuthCredentialsProviderBuilder builder = CredentialsProvider.newCredentialsProviderBuilder();
            int separatorIndex = this.properties.getBroker().getGatewayAddress().lastIndexOf(58);
            if (separatorIndex > 0) {
                builder.audience(this.properties.getBroker().getGatewayAddress().substring(0, separatorIndex));
            }
            return builder.build();
        }
        return null;
    }

    public String toString() {
        return "ZeebeClientConfigurationImpl{properties=" + String.valueOf(this.properties) + ", camundaClientProperties=" + String.valueOf(this.camundaClientProperties) + ", jsonMapper=" + String.valueOf(this.jsonMapper) + ", interceptors=" + String.valueOf(this.interceptors) + ", chainHandlers=" + String.valueOf(this.chainHandlers) + ", zeebeClientExecutorService=" + String.valueOf(this.zeebeClientExecutorService) + "}";
    }
}

