/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.configuration;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.worker.BackoffSupplier;
import io.camunda.zeebe.client.impl.worker.ExponentialBackoffBuilderImpl;
import io.camunda.zeebe.spring.client.annotation.customizer.ZeebeWorkerValueCustomizer;
import io.camunda.zeebe.spring.client.configuration.AnnotationProcessorConfiguration;
import io.camunda.zeebe.spring.client.configuration.JsonMapperConfiguration;
import io.camunda.zeebe.spring.client.configuration.PropertyUtil;
import io.camunda.zeebe.spring.client.configuration.condition.ConditionalOnCamundaClientEnabled;
import io.camunda.zeebe.spring.client.jobhandling.CommandExceptionHandlingStrategy;
import io.camunda.zeebe.spring.client.jobhandling.DefaultCommandExceptionHandlingStrategy;
import io.camunda.zeebe.spring.client.jobhandling.JobWorkerManager;
import io.camunda.zeebe.spring.client.jobhandling.ZeebeClientExecutorService;
import io.camunda.zeebe.spring.client.jobhandling.parameter.DefaultParameterResolverStrategy;
import io.camunda.zeebe.spring.client.jobhandling.parameter.ParameterResolverStrategy;
import io.camunda.zeebe.spring.client.jobhandling.result.DefaultResultProcessorStrategy;
import io.camunda.zeebe.spring.client.jobhandling.result.ResultProcessorStrategy;
import io.camunda.zeebe.spring.client.metrics.MetricsRecorder;
import io.camunda.zeebe.spring.client.properties.CamundaClientProperties;
import io.camunda.zeebe.spring.client.properties.PropertyBasedZeebeWorkerValueCustomizer;
import io.camunda.zeebe.spring.client.properties.ZeebeClientConfigurationProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@ConditionalOnCamundaClientEnabled
@Import(value={AnnotationProcessorConfiguration.class, JsonMapperConfiguration.class})
@EnableConfigurationProperties(value={ZeebeClientConfigurationProperties.class, CamundaClientProperties.class})
public class ZeebeClientAllAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ZeebeClientExecutorService zeebeClientExecutorService(ZeebeClientConfigurationProperties configurationProperties, CamundaClientProperties camundaClientProperties) {
        return ZeebeClientExecutorService.createDefault(PropertyUtil.getLegacyOrPropertyOrDefault("NumJobWorkerExecutionThreads", () -> camundaClientProperties.getZeebe().getExecutionThreads(), configurationProperties::getNumJobWorkerExecutionThreads, ZeebeClientConfigurationProperties.DEFAULT.getNumJobWorkerExecutionThreads(), null));
    }

    @Bean
    @ConditionalOnMissingBean
    public CommandExceptionHandlingStrategy commandExceptionHandlingStrategy(ZeebeClientExecutorService scheduledExecutorService) {
        return new DefaultCommandExceptionHandlingStrategy(this.backoffSupplier(), scheduledExecutorService.get());
    }

    @Bean
    @ConditionalOnMissingBean
    public ParameterResolverStrategy parameterResolverStrategy(JsonMapper jsonMapper) {
        return new DefaultParameterResolverStrategy(jsonMapper);
    }

    @Bean
    @ConditionalOnMissingBean
    public ResultProcessorStrategy resultProcessorStrategy() {
        return new DefaultResultProcessorStrategy();
    }

    @Bean
    public JobWorkerManager jobWorkerManager(CommandExceptionHandlingStrategy commandExceptionHandlingStrategy, MetricsRecorder metricsRecorder, ParameterResolverStrategy parameterResolverStrategy, ResultProcessorStrategy resultProcessorStrategy) {
        return new JobWorkerManager(commandExceptionHandlingStrategy, metricsRecorder, parameterResolverStrategy, resultProcessorStrategy);
    }

    @Bean
    public BackoffSupplier backoffSupplier() {
        return new ExponentialBackoffBuilderImpl().maxDelay(1000L).minDelay(50L).backoffFactor(1.5).jitterFactor(0.2).build();
    }

    @Bean(value={"propertyBasedZeebeWorkerValueCustomizer"})
    @ConditionalOnMissingBean(name={"propertyBasedZeebeWorkerValueCustomizer"})
    public ZeebeWorkerValueCustomizer propertyBasedZeebeWorkerValueCustomizer(ZeebeClientConfigurationProperties configurationProperties, CamundaClientProperties camundaClientProperties) {
        return new PropertyBasedZeebeWorkerValueCustomizer(configurationProperties, camundaClientProperties);
    }
}

