/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.configuration;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.worker.BackoffSupplier;
import io.camunda.zeebe.spring.client.annotation.customizer.ZeebeWorkerValueCustomizer;
import io.camunda.zeebe.spring.client.configuration.AnnotationProcessorConfiguration;
import io.camunda.zeebe.spring.client.configuration.JsonMapperConfiguration;
import io.camunda.zeebe.spring.client.configuration.ZeebeClientConfigurationImpl;
import io.camunda.zeebe.spring.client.configuration.condition.ConditionalOnCamundaClientEnabled;
import io.camunda.zeebe.spring.client.jobhandling.CommandExceptionHandlingStrategy;
import io.camunda.zeebe.spring.client.jobhandling.DefaultCommandExceptionHandlingStrategy;
import io.camunda.zeebe.spring.client.jobhandling.JobWorkerManager;
import io.camunda.zeebe.spring.client.jobhandling.ZeebeClientExecutorService;
import io.camunda.zeebe.spring.client.jobhandling.parameter.DefaultParameterResolverStrategy;
import io.camunda.zeebe.spring.client.jobhandling.parameter.ParameterResolverStrategy;
import io.camunda.zeebe.spring.client.jobhandling.result.DefaultResultProcessorStrategy;
import io.camunda.zeebe.spring.client.jobhandling.result.ResultProcessorStrategy;
import io.camunda.zeebe.spring.client.metrics.MetricsRecorder;
import io.camunda.zeebe.spring.client.properties.CamundaClientProperties;
import io.camunda.zeebe.spring.client.properties.PropertyBasedZeebeWorkerValueCustomizer;
import java.util.Optional;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@ConditionalOnCamundaClientEnabled
@Import(value={AnnotationProcessorConfiguration.class, JsonMapperConfiguration.class})
@EnableConfigurationProperties(value={CamundaClientProperties.class})
public class ZeebeClientAllAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ZeebeClientExecutorService zeebeClientExecutorService(CamundaClientProperties camundaClientProperties) {
        return ZeebeClientExecutorService.createDefault(Optional.ofNullable(camundaClientProperties.getZeebe().getExecutionThreads()).orElse(ZeebeClientConfigurationImpl.DEFAULT.getNumJobWorkerExecutionThreads()));
    }

    @Bean
    @ConditionalOnMissingBean
    public CommandExceptionHandlingStrategy commandExceptionHandlingStrategy(ZeebeClientExecutorService scheduledExecutorService) {
        return new DefaultCommandExceptionHandlingStrategy(this.backoffSupplier(), scheduledExecutorService.get());
    }

    @Bean
    @ConditionalOnMissingBean
    public ParameterResolverStrategy parameterResolverStrategy(JsonMapper jsonMapper) {
        return new DefaultParameterResolverStrategy(jsonMapper);
    }

    @Bean
    @ConditionalOnMissingBean
    public ResultProcessorStrategy resultProcessorStrategy() {
        return new DefaultResultProcessorStrategy();
    }

    @Bean
    public JobWorkerManager jobWorkerManager(CommandExceptionHandlingStrategy commandExceptionHandlingStrategy, MetricsRecorder metricsRecorder, ParameterResolverStrategy parameterResolverStrategy, ResultProcessorStrategy resultProcessorStrategy, BackoffSupplier backoffSupplier) {
        return new JobWorkerManager(commandExceptionHandlingStrategy, metricsRecorder, parameterResolverStrategy, resultProcessorStrategy, backoffSupplier);
    }

    @Bean
    @ConditionalOnMissingBean
    public BackoffSupplier backoffSupplier() {
        return BackoffSupplier.newBackoffBuilder().build();
    }

    @Bean(value={"propertyBasedZeebeWorkerValueCustomizer"})
    @ConditionalOnMissingBean(name={"propertyBasedZeebeWorkerValueCustomizer"})
    public ZeebeWorkerValueCustomizer propertyBasedZeebeWorkerValueCustomizer(CamundaClientProperties camundaClientProperties) {
        return new PropertyBasedZeebeWorkerValueCustomizer(camundaClientProperties);
    }
}

