/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.configuration;

import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.impl.ZeebeClientBuilderImpl;
import io.camunda.zeebe.spring.client.jobhandling.ZeebeClientExecutorService;
import io.camunda.zeebe.spring.client.properties.CamundaClientProperties;
import io.grpc.ClientInterceptor;
import java.net.MalformedURLException;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.unit.DataSize;

public class ZeebeClientConfigurationImpl
implements ZeebeClientConfiguration {
    public static final ZeebeClientBuilderImpl DEFAULT = (ZeebeClientBuilderImpl)new ZeebeClientBuilderImpl().withProperties(new Properties());
    private static final Logger LOG = LoggerFactory.getLogger(ZeebeClientConfigurationImpl.class);
    private final CamundaClientProperties camundaClientProperties;
    private final JsonMapper jsonMapper;
    private final List<ClientInterceptor> interceptors;
    private final List<AsyncExecChainHandler> chainHandlers;
    private final ZeebeClientExecutorService zeebeClientExecutorService;
    private final CredentialsProvider credentialsProvider;
    private final String gatewayAddress;
    private final boolean plaintext;

    @Autowired
    public ZeebeClientConfigurationImpl(CamundaClientProperties camundaClientProperties, JsonMapper jsonMapper, List<ClientInterceptor> interceptors, List<AsyncExecChainHandler> chainHandlers, ZeebeClientExecutorService zeebeClientExecutorService, CredentialsProvider credentialsProvider) {
        this.camundaClientProperties = camundaClientProperties;
        this.jsonMapper = jsonMapper;
        this.interceptors = interceptors;
        this.chainHandlers = chainHandlers;
        this.zeebeClientExecutorService = zeebeClientExecutorService;
        this.credentialsProvider = credentialsProvider;
        this.gatewayAddress = this.composeGatewayAddress();
        this.plaintext = this.composePlaintext();
    }

    public String getGatewayAddress() {
        return Optional.ofNullable(this.gatewayAddress).orElse(DEFAULT.getGatewayAddress());
    }

    public URI getRestAddress() {
        return Optional.ofNullable(this.camundaClientProperties.getZeebe().getRestAddress()).orElse(DEFAULT.getRestAddress());
    }

    public URI getGrpcAddress() {
        return Optional.ofNullable(this.camundaClientProperties.getZeebe().getGrpcAddress()).orElse(DEFAULT.getGrpcAddress());
    }

    public String getDefaultTenantId() {
        return Optional.ofNullable(this.camundaClientProperties.getTenantId()).orElse(DEFAULT.getDefaultTenantId());
    }

    public List<String> getDefaultJobWorkerTenantIds() {
        return Optional.ofNullable(this.camundaClientProperties.getZeebe().getDefaults().getTenantIds()).orElse(DEFAULT.getDefaultJobWorkerTenantIds());
    }

    public int getNumJobWorkerExecutionThreads() {
        return Optional.ofNullable(this.camundaClientProperties.getZeebe().getExecutionThreads()).orElse(DEFAULT.getNumJobWorkerExecutionThreads());
    }

    public int getDefaultJobWorkerMaxJobsActive() {
        return Optional.ofNullable(this.camundaClientProperties.getZeebe().getDefaults().getMaxJobsActive()).orElse(DEFAULT.getDefaultJobWorkerMaxJobsActive());
    }

    public String getDefaultJobWorkerName() {
        return Optional.ofNullable(this.camundaClientProperties.getZeebe().getDefaults().getName()).orElse(DEFAULT.getDefaultJobWorkerName());
    }

    public Duration getDefaultJobTimeout() {
        return Optional.ofNullable(this.camundaClientProperties.getZeebe().getDefaults().getTimeout()).orElse(DEFAULT.getDefaultJobTimeout());
    }

    public Duration getDefaultJobPollInterval() {
        return Optional.ofNullable(this.camundaClientProperties.getZeebe().getDefaults().getPollInterval()).orElse(DEFAULT.getDefaultJobPollInterval());
    }

    public Duration getDefaultMessageTimeToLive() {
        return Optional.ofNullable(this.camundaClientProperties.getZeebe().getMessageTimeToLive()).orElse(DEFAULT.getDefaultMessageTimeToLive());
    }

    public Duration getDefaultRequestTimeout() {
        return Optional.ofNullable(this.camundaClientProperties.getZeebe().getRequestTimeout()).orElse(DEFAULT.getDefaultRequestTimeout());
    }

    public Duration getDefaultRequestTimeoutOffset() {
        return Optional.ofNullable(this.camundaClientProperties.getZeebe().getRequestTimeoutOffset()).orElse(DEFAULT.getDefaultRequestTimeoutOffset());
    }

    public boolean isPlaintextConnectionEnabled() {
        return this.plaintext;
    }

    public String getCaCertificatePath() {
        return Optional.ofNullable(this.camundaClientProperties.getZeebe().getCaCertificatePath()).orElse(DEFAULT.getCaCertificatePath());
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public Duration getKeepAlive() {
        return Optional.ofNullable(this.camundaClientProperties.getZeebe().getKeepAlive()).orElse(DEFAULT.getKeepAlive());
    }

    public List<ClientInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public List<AsyncExecChainHandler> getChainHandlers() {
        return this.chainHandlers;
    }

    public JsonMapper getJsonMapper() {
        return this.jsonMapper;
    }

    public String getOverrideAuthority() {
        return Optional.ofNullable(this.camundaClientProperties.getZeebe().getOverrideAuthority()).orElse(DEFAULT.getOverrideAuthority());
    }

    public int getMaxMessageSize() {
        return Optional.ofNullable(this.camundaClientProperties.getZeebe().getMaxMessageSize()).map(DataSize::toBytes).map(Math::toIntExact).orElse(DEFAULT.getMaxMessageSize());
    }

    public int getMaxMetadataSize() {
        return Optional.ofNullable(this.camundaClientProperties.getZeebe().getMaxMetadataSize()).map(DataSize::toBytes).map(Math::toIntExact).orElse(DEFAULT.getMaxMetadataSize());
    }

    public ScheduledExecutorService jobWorkerExecutor() {
        return this.zeebeClientExecutorService.get();
    }

    public boolean ownsJobWorkerExecutor() {
        return this.zeebeClientExecutorService.isOwnedByZeebeClient();
    }

    public boolean getDefaultJobWorkerStreamEnabled() {
        return Optional.ofNullable(this.camundaClientProperties.getZeebe().getDefaults().getStreamEnabled()).orElse(DEFAULT.getDefaultJobWorkerStreamEnabled());
    }

    public boolean useDefaultRetryPolicy() {
        return false;
    }

    public boolean preferRestOverGrpc() {
        return Optional.ofNullable(this.camundaClientProperties.getZeebe().getPreferRestOverGrpc()).orElse(DEFAULT.preferRestOverGrpc());
    }

    private String composeGatewayAddress() {
        int defaultPort;
        URI gatewayUrl = this.getGrpcAddress();
        int port = gatewayUrl.getPort();
        String host = gatewayUrl.getHost();
        if (port != -1) {
            return this.composeAddressWithPort(host, port, "Gateway port is set");
        }
        try {
            defaultPort = gatewayUrl.toURL().getDefaultPort();
        }
        catch (MalformedURLException e) {
            LOG.warn("Invalid gateway url: {}", (Object)gatewayUrl);
            defaultPort = -1;
        }
        if (defaultPort != -1) {
            return this.composeAddressWithPort(host, defaultPort, "Gateway port has default");
        }
        LOG.debug("Gateway cannot be determined, address will be '{}'", (Object)host);
        return host;
    }

    private String composeAddressWithPort(String host, int port, String debugMessage) {
        String gatewayAddress = host + ":" + port;
        LOG.debug(debugMessage + ", address will be '{}'", (Object)gatewayAddress);
        return gatewayAddress;
    }

    private boolean composePlaintext() {
        String protocol;
        return switch (protocol = this.getGrpcAddress().getScheme()) {
            case "http", "grpc" -> true;
            case "https", "grpcs" -> false;
            default -> throw new IllegalStateException(String.format("Unrecognized zeebe protocol '%s'", protocol));
        };
    }

    public String toString() {
        return "ZeebeClientConfigurationImpl{camundaClientProperties=" + String.valueOf(this.camundaClientProperties) + ", jsonMapper=" + String.valueOf(this.jsonMapper) + ", interceptors=" + String.valueOf(this.interceptors) + ", chainHandlers=" + String.valueOf(this.chainHandlers) + ", zeebeClientExecutorService=" + String.valueOf(this.zeebeClientExecutorService) + ", credentialsProvider=" + String.valueOf(this.credentialsProvider) + "}";
    }
}

