/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.jobhandling;

import io.camunda.zeebe.spring.client.configuration.ZeebeClientConfigurationImpl;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class ZeebeClientExecutorService {
    private final ScheduledExecutorService scheduledExecutorService;
    private final boolean ownedByZeebeClient;

    public ZeebeClientExecutorService(ScheduledExecutorService scheduledExecutorService, boolean ownedByZeebeClient) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.ownedByZeebeClient = ownedByZeebeClient;
    }

    public boolean isOwnedByZeebeClient() {
        return this.ownedByZeebeClient;
    }

    public ScheduledExecutorService get() {
        return this.scheduledExecutorService;
    }

    public static ZeebeClientExecutorService createDefault() {
        return ZeebeClientExecutorService.createDefault(ZeebeClientConfigurationImpl.DEFAULT.getNumJobWorkerExecutionThreads());
    }

    public static ZeebeClientExecutorService createDefault(int threads) {
        ScheduledExecutorService threadPool = Executors.newScheduledThreadPool(threads);
        return new ZeebeClientExecutorService(threadPool, true);
    }
}

