/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.properties.common;

import io.camunda.zeebe.spring.client.annotation.value.ZeebeWorkerValue;
import io.camunda.zeebe.spring.client.properties.common.ApiProperties;
import java.net.URI;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.unit.DataSize;

public class ZeebeClientProperties
extends ApiProperties {
    private Integer executionThreads;
    private Duration messageTimeToLive;
    private DataSize maxMessageSize;
    private DataSize maxMetadataSize;
    private Duration requestTimeout;
    private Duration requestTimeoutOffset;
    private String caCertificatePath;
    private Duration keepAlive;
    private String overrideAuthority;
    @NestedConfigurationProperty
    private ZeebeWorkerValue defaults = new ZeebeWorkerValue();
    @NestedConfigurationProperty
    private Map<String, ZeebeWorkerValue> override = new HashMap<String, ZeebeWorkerValue>();
    private Boolean preferRestOverGrpc;
    private URI grpcAddress;
    private URI restAddress;

    public ZeebeWorkerValue getDefaults() {
        return this.defaults;
    }

    public void setDefaults(ZeebeWorkerValue defaults) {
        this.defaults = defaults;
    }

    public Map<String, ZeebeWorkerValue> getOverride() {
        return this.override;
    }

    public void setOverride(Map<String, ZeebeWorkerValue> override) {
        this.override = override;
    }

    public Integer getExecutionThreads() {
        return this.executionThreads;
    }

    public void setExecutionThreads(Integer executionThreads) {
        this.executionThreads = executionThreads;
    }

    public Duration getMessageTimeToLive() {
        return this.messageTimeToLive;
    }

    public void setMessageTimeToLive(Duration messageTimeToLive) {
        this.messageTimeToLive = messageTimeToLive;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public Duration getRequestTimeoutOffset() {
        return this.requestTimeoutOffset;
    }

    public void setRequestTimeoutOffset(Duration requestTimeoutOffset) {
        this.requestTimeoutOffset = requestTimeoutOffset;
    }

    public String getCaCertificatePath() {
        return this.caCertificatePath;
    }

    public void setCaCertificatePath(String caCertificatePath) {
        this.caCertificatePath = caCertificatePath;
    }

    public Duration getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(Duration keepAlive) {
        this.keepAlive = keepAlive;
    }

    public String getOverrideAuthority() {
        return this.overrideAuthority;
    }

    public void setOverrideAuthority(String overrideAuthority) {
        this.overrideAuthority = overrideAuthority;
    }

    public DataSize getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(DataSize maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public DataSize getMaxMetadataSize() {
        return this.maxMetadataSize;
    }

    public void setMaxMetadataSize(DataSize maxMetadataSize) {
        this.maxMetadataSize = maxMetadataSize;
    }

    public Boolean getPreferRestOverGrpc() {
        return this.preferRestOverGrpc;
    }

    public void setPreferRestOverGrpc(Boolean preferRestOverGrpc) {
        this.preferRestOverGrpc = preferRestOverGrpc;
    }

    public URI getGrpcAddress() {
        return this.grpcAddress;
    }

    public void setGrpcAddress(URI grpcAddress) {
        if (grpcAddress != null && grpcAddress.getHost() == null) {
            throw new IllegalArgumentException("grpcAddress must be an absolute URI");
        }
        this.grpcAddress = grpcAddress;
    }

    public URI getRestAddress() {
        return this.restAddress;
    }

    public void setRestAddress(URI restAddress) {
        if (restAddress != null && restAddress.getHost() == null) {
            throw new IllegalArgumentException("restAddress must be an absolute URI");
        }
        this.restAddress = restAddress;
    }

    public String toString() {
        return "ZeebeClientProperties{executionThreads=" + this.executionThreads + ", messageTimeToLive=" + String.valueOf(this.messageTimeToLive) + ", maxMessageSize=" + String.valueOf(this.maxMessageSize) + ", maxMetadataSize=" + String.valueOf(this.maxMetadataSize) + ", requestTimeout=" + String.valueOf(this.requestTimeout) + ", caCertificatePath='" + this.caCertificatePath + "', keepAlive=" + String.valueOf(this.keepAlive) + ", overrideAuthority='" + this.overrideAuthority + "', defaults=" + String.valueOf(this.defaults) + ", override=" + String.valueOf(this.override) + ", preferRestOverGrpc=" + this.preferRestOverGrpc + ", grpcAddress=" + String.valueOf(this.grpcAddress) + ", restAddress=" + String.valueOf(this.restAddress) + "} " + super.toString();
    }
}

