/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.configuration;

import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.impl.NoopCredentialsProvider;
import io.camunda.zeebe.client.impl.oauth.OAuthCredentialsProviderBuilder;
import io.camunda.zeebe.spring.client.properties.CamundaClientProperties;
import java.net.URI;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CredentialsProviderConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(CredentialsProviderConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public CredentialsProvider camundaClientCredentialsProvider(CamundaClientProperties camundaClientProperties) {
        if (camundaClientProperties.getMode() == null) {
            return new NoopCredentialsProvider();
        }
        OAuthCredentialsProviderBuilder credBuilder = CredentialsProvider.newCredentialsProviderBuilder().applyEnvironmentOverrides(false).clientId(camundaClientProperties.getAuth().getClientId()).clientSecret(camundaClientProperties.getAuth().getClientSecret()).audience(camundaClientProperties.getZeebe().getAudience()).scope(camundaClientProperties.getZeebe().getScope()).authorizationServerUrl((String)Optional.ofNullable(camundaClientProperties.getAuth().getTokenUrl()).map(URI::toString).orElse(null)).credentialsCachePath(camundaClientProperties.getAuth().getCredentialsCachePath()).connectTimeout(camundaClientProperties.getAuth().getConnectTimeout()).readTimeout(camundaClientProperties.getAuth().getReadTimeout()).clientAssertionKeystorePath(camundaClientProperties.getAuth().getClientAssertion().getKeystorePath()).clientAssertionKeystorePassword(camundaClientProperties.getAuth().getClientAssertion().getKeystorePassword()).clientAssertionKeystoreKeyAlias(camundaClientProperties.getAuth().getClientAssertion().getKeystoreKeyAlias()).clientAssertionKeystoreKeyPassword(camundaClientProperties.getAuth().getClientAssertion().getKeystoreKeyPassword());
        try {
            return credBuilder.build();
        }
        catch (Exception e) {
            LOG.warn("Failed to configure oidc credential provider, falling back to use no authentication, cause: {}", (Object)e.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getMessage(), (Throwable)e);
            }
            return new NoopCredentialsProvider();
        }
    }
}

