/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.spring.client.annotation;

import io.camunda.spring.client.annotation.CustomHeaders;
import io.camunda.spring.client.annotation.Deployment;
import io.camunda.spring.client.annotation.JobWorker;
import io.camunda.spring.client.annotation.Variable;
import io.camunda.spring.client.annotation.VariablesAsType;
import io.camunda.spring.client.annotation.value.DeploymentValue;
import io.camunda.spring.client.annotation.value.JobWorkerValue;
import io.camunda.spring.client.annotation.value.VariableValue;
import io.camunda.spring.client.bean.BeanInfo;
import io.camunda.spring.client.bean.ClassInfo;
import io.camunda.spring.client.bean.MethodInfo;
import io.camunda.spring.client.bean.ParameterInfo;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationUtil.class);

    public static boolean isVariable(ParameterInfo parameterInfo) {
        return parameterInfo.getParameterInfo().isAnnotationPresent(Variable.class) || AnnotationUtil.isVariableLegacy(parameterInfo);
    }

    public static List<ParameterInfo> getVariableParameters(MethodInfo methodInfo) {
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>();
        result.addAll(methodInfo.getParametersFilteredByAnnotation(Variable.class));
        result.addAll(methodInfo.getParametersFilteredByAnnotation(io.camunda.zeebe.spring.client.annotation.Variable.class));
        return result;
    }

    public static List<ParameterInfo> getVariablesAsTypeParameters(MethodInfo methodInfo) {
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>();
        result.addAll(methodInfo.getParametersFilteredByAnnotation(VariablesAsType.class));
        result.addAll(methodInfo.getParametersFilteredByAnnotation(io.camunda.zeebe.spring.client.annotation.VariablesAsType.class));
        return result;
    }

    public static boolean isVariablesAsType(ParameterInfo parameterInfo) {
        return parameterInfo.getParameterInfo().isAnnotationPresent(VariablesAsType.class) || AnnotationUtil.isVariablesAsTypeLegacy(parameterInfo);
    }

    public static boolean isCustomHeaders(ParameterInfo parameterInfo) {
        return parameterInfo.getParameterInfo().isAnnotationPresent(CustomHeaders.class) || AnnotationUtil.isCustomHeadersLegacy(parameterInfo);
    }

    public static boolean isDeployment(ClassInfo classInfo) {
        return classInfo.hasClassAnnotation(Deployment.class) || AnnotationUtil.isDeploymentLegacy(classInfo);
    }

    public static boolean isJobWorker(BeanInfo beanInfo) {
        return beanInfo.hasMethodAnnotation(JobWorker.class) || AnnotationUtil.isJobWorkerLegacy(beanInfo);
    }

    private static boolean isJobWorkerLegacy(BeanInfo beanInfo) {
        return beanInfo.hasMethodAnnotation(io.camunda.zeebe.spring.client.annotation.JobWorker.class);
    }

    public static Optional<JobWorkerValue> getJobWorkerValue(MethodInfo methodInfo) {
        return AnnotationUtil.getJobWorkerValueInternal(methodInfo).or(() -> AnnotationUtil.getJobWorkerValueLegacyInternal(methodInfo));
    }

    private static Optional<JobWorkerValue> getJobWorkerValueInternal(MethodInfo methodInfo) {
        Optional<JobWorker> methodAnnotation = methodInfo.getAnnotation(JobWorker.class);
        if (methodAnnotation.isPresent()) {
            JobWorker annotation = methodAnnotation.get();
            return Optional.of(new JobWorkerValue(annotation.type(), annotation.name(), Duration.of(annotation.timeout(), ChronoUnit.MILLIS), annotation.maxJobsActive(), Duration.of(annotation.requestTimeout(), ChronoUnit.SECONDS), Duration.of(annotation.pollInterval(), ChronoUnit.MILLIS), annotation.autoComplete(), Arrays.asList(annotation.fetchVariables()), annotation.enabled(), methodInfo, Arrays.asList(annotation.tenantIds()), annotation.fetchAllVariables(), annotation.streamEnabled(), Duration.of(annotation.streamTimeout(), ChronoUnit.MILLIS), annotation.maxRetries()));
        }
        return Optional.empty();
    }

    private static Optional<JobWorkerValue> getJobWorkerValueLegacyInternal(MethodInfo methodInfo) {
        Optional<io.camunda.zeebe.spring.client.annotation.JobWorker> methodAnnotation = methodInfo.getAnnotation(io.camunda.zeebe.spring.client.annotation.JobWorker.class);
        if (methodAnnotation.isPresent()) {
            io.camunda.zeebe.spring.client.annotation.JobWorker annotation = methodAnnotation.get();
            return Optional.of(new JobWorkerValue(annotation.type(), annotation.name(), Duration.of(annotation.timeout(), ChronoUnit.MILLIS), annotation.maxJobsActive(), Duration.of(annotation.requestTimeout(), ChronoUnit.SECONDS), Duration.of(annotation.pollInterval(), ChronoUnit.MILLIS), annotation.autoComplete(), Arrays.asList(annotation.fetchVariables()), annotation.enabled(), methodInfo, Arrays.asList(annotation.tenantIds()), annotation.fetchAllVariables(), annotation.streamEnabled(), Duration.of(annotation.streamTimeout(), ChronoUnit.MILLIS), annotation.maxRetries()));
        }
        return Optional.empty();
    }

    public static Optional<VariableValue> getVariableValue(ParameterInfo parameterInfo) {
        if (AnnotationUtil.isVariable(parameterInfo)) {
            if (!AnnotationUtil.isVariableLegacy(parameterInfo)) {
                return Optional.of(new VariableValue(AnnotationUtil.getVariableName(parameterInfo), parameterInfo, AnnotationUtil.getVariableOptional(parameterInfo)));
            }
            return Optional.of(new VariableValue(AnnotationUtil.getVariableNameLegacy(parameterInfo), parameterInfo, true));
        }
        return Optional.empty();
    }

    public static Optional<DeploymentValue> getDeploymentValue(ClassInfo beanInfo) {
        if (AnnotationUtil.isDeployment(beanInfo)) {
            ArrayList<String> resources = new ArrayList<String>();
            resources.addAll(AnnotationUtil.getDeploymentResources(beanInfo));
            resources.addAll(AnnotationUtil.getDeploymentResourcesLegacy(beanInfo));
            return Optional.of(DeploymentValue.builder().beanInfo(beanInfo).resources(resources).build());
        }
        return Optional.empty();
    }

    private static List<String> getDeploymentResources(ClassInfo beanInfo) {
        return beanInfo.getAnnotation(Deployment.class).map(Deployment::resources).map(Arrays::asList).orElseGet(List::of);
    }

    private static List<String> getDeploymentResourcesLegacy(ClassInfo beanInfo) {
        return beanInfo.getAnnotation(io.camunda.zeebe.spring.client.annotation.Deployment.class).map(io.camunda.zeebe.spring.client.annotation.Deployment::resources).map(Arrays::asList).orElseGet(List::of);
    }

    private static boolean isVariableLegacy(ParameterInfo parameterInfo) {
        return parameterInfo.getParameterInfo().isAnnotationPresent(io.camunda.zeebe.spring.client.annotation.Variable.class);
    }

    private static boolean isVariablesAsTypeLegacy(ParameterInfo parameterInfo) {
        return parameterInfo.getParameterInfo().isAnnotationPresent(io.camunda.zeebe.spring.client.annotation.VariablesAsType.class);
    }

    private static boolean isCustomHeadersLegacy(ParameterInfo parameterInfo) {
        return parameterInfo.getParameterInfo().isAnnotationPresent(io.camunda.zeebe.spring.client.annotation.CustomHeaders.class);
    }

    public static boolean isDeploymentLegacy(ClassInfo classInfo) {
        return classInfo.hasClassAnnotation(io.camunda.zeebe.spring.client.annotation.Deployment.class);
    }

    private static String getVariableName(ParameterInfo param) {
        if (param.getParameterInfo().isAnnotationPresent(Variable.class)) {
            String nameFromAnnotation = param.getParameterInfo().getAnnotation(Variable.class).name();
            if (StringUtils.isNotBlank((CharSequence)nameFromAnnotation)) {
                LOG.trace("Extracting name {} from Variable.name", (Object)nameFromAnnotation);
                return nameFromAnnotation;
            }
            String valueFromAnnotation = param.getParameterInfo().getAnnotation(Variable.class).value();
            if (StringUtils.isNotBlank((CharSequence)valueFromAnnotation)) {
                LOG.trace("Extracting name {} from Variable.value", (Object)valueFromAnnotation);
                return valueFromAnnotation;
            }
        }
        LOG.trace("Extracting variable name from parameter name");
        return param.getParameterName();
    }

    private static boolean getVariableOptional(ParameterInfo param) {
        if (param.getParameterInfo().isAnnotationPresent(Variable.class)) {
            boolean optional = param.getParameterInfo().getAnnotation(Variable.class).optional();
            LOG.trace("Extracting optional flag from Variable");
            return optional;
        }
        LOG.trace("No variable annotation found, defaulting to true");
        return true;
    }

    private static String getVariableNameLegacy(ParameterInfo param) {
        if (param.getParameterInfo().isAnnotationPresent(io.camunda.zeebe.spring.client.annotation.Variable.class)) {
            String nameFromAnnotation = param.getParameterInfo().getAnnotation(io.camunda.zeebe.spring.client.annotation.Variable.class).name();
            if (!Objects.equals(nameFromAnnotation, "$NULL$")) {
                LOG.trace("Extracting name {} from Variable.name", (Object)nameFromAnnotation);
                return nameFromAnnotation;
            }
            String valueFromAnnotation = param.getParameterInfo().getAnnotation(io.camunda.zeebe.spring.client.annotation.Variable.class).value();
            if (!Objects.equals(valueFromAnnotation, "$NULL$")) {
                LOG.trace("Extracting name {} from Variable.value", (Object)valueFromAnnotation);
                return valueFromAnnotation;
            }
        }
        LOG.trace("Extracting variable name from parameter name");
        return param.getParameterName();
    }
}

