/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.spring.client.annotation.processor;

import io.camunda.client.CamundaClient;
import io.camunda.spring.client.annotation.processor.CamundaClientLifecycleAware;
import io.camunda.spring.client.bean.ClassInfo;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractCamundaAnnotationProcessor
implements ApplicationContextAware,
CamundaClientLifecycleAware {
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected abstract boolean isApplicableFor(ClassInfo var1);

    protected abstract void configureFor(ClassInfo var1);

    protected abstract void start(CamundaClient var1);

    protected abstract void stop(CamundaClient var1);

    @Override
    public void onStart(CamundaClient client) {
        for (String beanName : this.applicationContext.getBeanDefinitionNames()) {
            Object bean = this.applicationContext.getBean(beanName);
            ClassInfo classInfo = ClassInfo.builder().beanName(beanName).bean(bean).build();
            if (!this.isApplicableFor(classInfo)) continue;
            this.configureFor(classInfo);
        }
        this.start(client);
    }

    @Override
    public void onStop(CamundaClient client) {
        this.stop(client);
    }
}

