/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.spring.client.bean;

import io.camunda.spring.client.bean.BeanInfo;
import io.camunda.spring.client.bean.ClassInfo;
import io.camunda.spring.client.bean.ParameterInfo;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.StandardReflectionParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;

public class MethodInfo
implements BeanInfo {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final StandardReflectionParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new StandardReflectionParameterNameDiscoverer();
    protected ClassInfo classInfo;
    protected Method method;

    protected MethodInfo(ClassInfo classInfo, Method method) {
        this.classInfo = classInfo;
        this.method = method;
    }

    protected MethodInfo(MethodInfo original) {
        this.classInfo = original.classInfo;
        this.method = original.method;
    }

    @Override
    public Object getBean() {
        return this.classInfo.getBean();
    }

    @Override
    public String getBeanName() {
        return this.classInfo.getBeanName();
    }

    public String toString() {
        return "MethodInfo{classInfo=" + String.valueOf(this.classInfo) + ", method=" + String.valueOf(this.method) + "}";
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public Object invoke(Object ... args) throws Exception {
        try {
            return this.method.invoke(this.getBean(), args);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof Exception) {
                throw (Exception)targetException;
            }
            throw new RuntimeException("Failed to invoke method: " + this.method.getName(), targetException);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to invoke method: " + this.method.getName(), e);
        }
    }

    public <T extends Annotation> Optional<T> getAnnotation(Class<T> type) {
        return Optional.ofNullable(AnnotationUtils.findAnnotation((Method)this.method, type));
    }

    public List<ParameterInfo> getParameters() {
        Parameter[] parameters = this.method.getParameters();
        String[] parameterNames = this.getParameterNames();
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>();
        for (int i = 0; i < parameters.length; ++i) {
            result.add(new ParameterInfo(this, parameters[i], parameterNames[i]));
        }
        return result;
    }

    private String[] getParameterNames() {
        String[] parameterNames = PARAMETER_NAME_DISCOVERER.getParameterNames(this.method);
        if (parameterNames == null) {
            LOG.warn("Parameter names of method " + this.method.getName() + " could not be discovered. Please set compiler flag -parameters if you rely on parameter names (e.g. for variable names to fetch from Zeebe)");
            Parameter[] parameters = this.method.getParameters();
            parameterNames = new String[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                parameterNames[i] = "arg" + i;
            }
        }
        return parameterNames;
    }

    public List<ParameterInfo> getParametersFilteredByAnnotation(Class type) {
        Parameter[] parameters = this.method.getParameters();
        String[] parameterNames = this.getParameterNames();
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].isAnnotationPresent(type)) continue;
            result.add(new ParameterInfo(this, parameters[i], parameterNames[i]));
        }
        return result;
    }

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public static MethodInfoBuilder builder() {
        return new MethodInfoBuilder();
    }

    public static final class MethodInfoBuilder {
        private ClassInfo classInfo;
        private Method method;

        private MethodInfoBuilder() {
        }

        public MethodInfoBuilder classInfo(ClassInfo classInfo) {
            this.classInfo = classInfo;
            return this;
        }

        public MethodInfoBuilder method(Method method) {
            this.method = method;
            return this;
        }

        public MethodInfo build() {
            return new MethodInfo(this.classInfo, this.method);
        }
    }
}

